<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("
            CREATE VIEW vw_colourways AS
            SELECT 
                c.id,
                c.style_versions_id,
                c.name,
                c.image,
                c.comments,
                c.created_at,
                c.updated_at,
                c.cancelled,
                c.accessories,
                c.colour_type,
                c.img_thumb,
                c.deleted_at,
                c.composition,
                c.customer_description,
                c.testing_comments,
                c.colour_approval_comments,
                COALESCE(
                    (
                        SELECT SUM(
                            CASE 
                                WHEN yc.id IS NOT NULL THEN
                                    CASE 
                                        WHEN s.currency = '€' THEN cy.price * (cy.percentage / 100)
                                        WHEN s.currency = '£' THEN cy.price * (cy.percentage / 100) * se.euro_rate
                                        WHEN s.currency = '$' THEN cy.price * (cy.percentage / 100) * se.usd_rate
                                        ELSE cy.price * (cy.percentage / 100)
                                    END
                                ELSE 0
                            END
                        )
                        FROM colourway_yarns cy
                        LEFT JOIN yarn_colours yc ON cy.yarn_colours_id = yc.id
                        LEFT JOIN yarns y ON yc.yarn_id = y.id
                        LEFT JOIN suppliers s ON y.suppliers_id = s.id
                        LEFT JOIN style_versions sv ON c.style_versions_id = sv.id
                        LEFT JOIN styles st ON sv.styles_id = st.id
                        LEFT JOIN seasons se ON st.seasons_id = se.id
                        WHERE cy.colourways_id = c.id
                        AND cy.deleted_at IS NULL
                        AND yc.deleted_at IS NULL
                        AND y.deleted_at IS NULL
                        AND s.deleted_at IS NULL
                        AND sv.deleted_at IS NULL
                        AND st.deleted_at IS NULL
                        AND se.deleted_at IS NULL
                    ), 0
                ) AS yarn_cost_kg_eur
            FROM colourways c
            WHERE c.deleted_at IS NULL
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::statement('DROP VIEW IF EXISTS vw_colourways');
    }
};
