<?php

namespace App\Contracts;

use App\Models\AiContextSummary;
use App\Models\User;

interface MemoryService
{
    /**
     * Create a monthly context summary from recent user check-ins.
     */
    public function createMonthlySummary(User $user, ?\DateTimeInterface $monthStart = null): AiContextSummary;

    /**
     * Keep only the newest N summaries; delete older ones.
     * Returns number of deleted rows.
     */
    public function rotateSummaries(User $user, int $keep = 12): int;
}


