<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-2">
                    <li class="breadcrumb-item">
                        <a href="{{ route('admin.seasons') }}" class="text-decoration-none">Seasons</a>
                    </li>
                    <li class="breadcrumb-item active">{{ $season->name }}</li>
                </ol>
            </nav>
            <h1 class="h3 mb-1">Season Details</h1>
            <p class="text-muted mb-0">View and manage season information and items</p>
        </div>
        <div class="btn-group">
            @if($editing)
                <button wire:click="save" class="btn btn-success">
                    <i class="bi bi-check-lg me-2"></i>Save Changes
                </button>
                <button wire:click="cancel" class="btn btn-outline-secondary">
                    <i class="bi bi-x-lg me-2"></i>Cancel
                </button>
            @else
                <button wire:click="toggleEdit" class="btn btn-primary">
                    <i class="bi bi-pencil me-2"></i>Edit Season
                </button>
            @endif
        </div>
    </div>

    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
</div>
