<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-2">
                    <li class="breadcrumb-item">
                        <a href="{{ route('admin.seasons') }}" class="text-decoration-none">Seasons</a>
                    </li>
                    <li class="breadcrumb-item active">{{ $season->name }}</li>
                </ol>
            </nav>
            <h1 class="h3 mb-1">Season Details</h1>
            <p class="text-muted mb-0">View and manage season information and items</p>
        </div>
        <div class="btn-group">
            @if($editing)
                <button wire:click="save" class="btn btn-success">
                    <i class="bi bi-check-lg me-2"></i>Save Changes
                </button>
                <button wire:click="cancel" class="btn btn-outline-secondary">
                    <i class="bi bi-x-lg me-2"></i>Cancel
                </button>
            @else
                <button wire:click="toggleEdit" class="btn btn-primary">
                    <i class="bi bi-pencil me-2"></i>Edit Season
                </button>
            @endif
        </div>
    </div>

    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <!-- Season Information -->
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-calendar3 me-2"></i>Season Information
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Basic Information -->
                    <div class="row g-4 mb-4">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-tag text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0">Season Name</label>
                            </div>
                            @if($editing)
                                <input type="text" 
                                       wire:model="name" 
                                       class="form-control @error('name') is-invalid @enderror">
                                @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="fs-5 fw-medium text-body">{{ $season->name }}</div>
                            @endif
                        </div>
                        
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-link-45deg text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0">URL Slug</label>
                            </div>
                            @if($editing)
                                <input type="text" 
                                       wire:model="slug" 
                                       class="form-control @error('slug') is-invalid @enderror">
                                @error('slug') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="fs-5 fw-medium text-body">{{ $season->slug }}</div>
                            @endif
                        </div>
                    </div>

                    <!-- Description -->
                    <div class="border-top pt-4 mb-4">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-file-text text-primary me-2"></i>
                            <label class="form-label fw-semibold mb-0">Description</label>
                        </div>
                        @if($editing)
                            <textarea wire:model="description" 
                                      class="form-control @error('description') is-invalid @enderror" 
                                      rows="3" 
                                      placeholder="Enter season description..."></textarea>
                            @error('description') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        @else
                            <div class="text-body">
                                {{ $season->description ?: 'No description provided' }}
                            </div>
                        @endif
                    </div>

                    <!-- Dates and Settings -->
                    <div class="border-top pt-4">
                        <div class="row g-4">
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-calendar-plus text-primary me-2"></i>
                                    <label class="form-label fw-semibold mb-0">Start Date</label>
                                </div>
                                @if($editing)
                                    <input type="date" 
                                           wire:model="startDate" 
                                           class="form-control @error('startDate') is-invalid @enderror">
                                    @error('startDate') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                    <div class="fs-5 fw-medium text-body">
                                        {{ $season->start_date ? $season->start_date->format('M j, Y') : 'Not set' }}
                                    </div>
                                @endif
                            </div>
                            
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-calendar-check text-primary me-2"></i>
                                    <label class="form-label fw-semibold mb-0">End Date</label>
                                </div>
                                @if($editing)
                                    <input type="date" 
                                           wire:model="endDate" 
                                           class="form-control @error('endDate') is-invalid @enderror">
                                    @error('endDate') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                    <div class="fs-5 fw-medium text-body">
                                        {{ $season->end_date ? $season->end_date->format('M j, Y') : 'Not set' }}
                                    </div>
                                @endif
                            </div>
                            
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-sort-numeric-up text-primary me-2"></i>
                                    <label class="form-label fw-semibold mb-0">Sort Order</label>
                                </div>
                                @if($editing)
                                    <input type="number" 
                                           wire:model="sortOrder" 
                                           class="form-control @error('sortOrder') is-invalid @enderror" 
                                           min="0">
                                    @error('sortOrder') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                    <span class="badge bg-light text-dark fs-6">{{ $season->sort_order }}</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
