<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statements', function (Blueprint $table) {
            $table->id();
            $table->string('cardholder_name');
            $table->string('masked_account_number');
            $table->string('statement_cycle')->nullable();
            $table->date('period_start_date')->nullable();
            $table->date('period_end_date')->nullable();
            $table->string('currency', 3)->nullable();
            $table->enum('status', ['open', 'closed'])->default('open');
            $table->string('source_filename')->nullable();
            $table->timestamps();

            $table->index(['masked_account_number', 'period_start_date', 'period_end_date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statements');
    }
};
