<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Receipt extends Model
{
    use HasFactory;

    protected $fillable = [
        'uploaded_at',
        'purchase_date',
        'merchant_name',
        'total_amount',
        'currency',
        'source',
        'image_path',
        'status',
        'notes',
        'is_personal',
    ];

    protected $casts = [
        'uploaded_at' => 'datetime',
        'purchase_date' => 'date',
        'total_amount' => 'decimal:2',
        'is_personal' => 'boolean',
    ];

    public function items(): HasMany
    {
        return $this->hasMany(ReceiptItem::class);
    }
}
