<div>
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <h1 class="fw-bold mb-0">My Profile</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-3 mb-4 mb-lg-0">
            @include('partials.account-sidebar')
        </div>

        <div class="col-lg-9">
            <!-- Profile Information -->
            <div class="ys-card p-4 mb-4">
                <h4 class="fw-bold mb-4">Profile Information</h4>
                
                @if(session('message'))
                    <div class="alert alert-success alert-dismissible fade show">
                        {{ session('message') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <form wire:submit.prevent="updateProfile">
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Name</label>
                        <input type="text" wire:model="name" class="form-control @error('name') is-invalid @enderror">
                        @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Email</label>
                        <input type="email" wire:model="email" class="form-control @error('email') is-invalid @enderror">
                        @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-4">
                        <div class="form-check">
                            <input type="checkbox" wire:model="marketing_consent" class="form-check-input" id="marketing">
                            <label class="form-check-label" for="marketing">
                                I would like to receive marketing emails about new products and special offers
                            </label>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-ys-primary">
                        Save Changes
                    </button>
                </form>
            </div>

            <!-- Change Password -->
            <div class="ys-card p-4">
                <h4 class="fw-bold mb-4">Change Password</h4>
                
                @if(session('password_message'))
                    <div class="alert alert-success alert-dismissible fade show">
                        {{ session('password_message') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <form wire:submit.prevent="updatePassword">
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Current Password</label>
                        <input type="password" wire:model="current_password" class="form-control @error('current_password') is-invalid @enderror">
                        @error('current_password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">New Password</label>
                        <input type="password" wire:model="password" class="form-control @error('password') is-invalid @enderror">
                        @error('password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-4">
                        <label class="form-label fw-semibold">Confirm New Password</label>
                        <input type="password" wire:model="password_confirmation" class="form-control">
                    </div>

                    <button type="submit" class="btn btn-ys-primary">
                        Update Password
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
</div>

