<?php

namespace App\Http\Controllers\Api\V1;

use App\Contracts\SafetyService;
use App\Http\Controllers\Controller;
use App\Models\UserCheckin;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CheckinsController extends Controller
{
    public function store(Request $request, SafetyService $safety)
    {
        $validated = $request->validate([
            'note' => ['required', 'string', 'max:2000'],
        ]);

        $user = $request->user();
        $result = $safety->evaluateText($validated['note']);

        if ($result['action'] === 'route_resources') {
            // Still log event, but do not persist raw text
            $safety->checkAndLog('checkin', $validated['note'], $user);
            return response()->json(['status' => 'routed_resources'], 202);
        }

        $textToPersist = $validated['note'];
        if ($result['action'] === 'redact') {
            $textToPersist = $safety->redact($textToPersist);
        }

        $checkin = UserCheckin::create([
            'id' => (string) Str::uuid(),
            'user_id' => $user->id,
            'note' => $textToPersist,
            'created_at' => now(),
        ]);

        $safety->checkAndLog('checkin', $validated['note'], $user);

        return response()->json($checkin);
    }
}


