<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statements', function (Blueprint $table) {
            $table->id();
            $table->string('cardholder_name');
            $table->string('account_number_masked')->index();
            $table->date('period_start')->index();
            $table->date('period_end')->index();
            $table->string('currency', 3)->default('GBP');
            $table->enum('status', ['open', 'closed'])->default('open')->index();
            $table->foreignId('uploaded_by_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('source_filename')->nullable();
            $table->string('storage_path')->nullable();
            $table->string('file_hash', 128)->nullable();
            $table->json('meta')->nullable();
            $table->timestamps();
            $table->index(['account_number_masked', 'period_start', 'period_end'], 'statements_account_period_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statements');
    }
};
