# Laravel Livewire App with Bootstrap and Breeze

A modern Laravel application built with Livewire, Bootstrap 5, and Laravel Breeze for authentication.

## Features

- **Laravel 12** - Latest Laravel framework
- **Livewire 3** - Full-stack framework for Laravel
- **Bootstrap 5** - Latest Bootstrap CSS framework
- **Laravel Breeze** - Authentication scaffolding with Livewire stack
- **PostgreSQL Database** - Robust, production-ready database with advanced features
- **Vite** - Modern frontend build tool

## Prerequisites

- PHP 8.2 or higher
- Composer
- Node.js and npm
- PostgreSQL 16 (or higher)
- PostgreSQL command line tools (optional, for database management)

## Installation

1. **Clone the repository**
   ```bash
   git clone <your-repo-url>
   cd laravel-livewire-app
   ```

2. **Install PHP dependencies**
   ```bash
   composer install
   ```

3. **Install Node.js dependencies**
   ```bash
   npm install
   ```

4. **Environment setup**
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

5. **Database setup**
   ```bash
   # Create PostgreSQL database
   createdb laravel_livewire_app
   
   # Or using psql
   psql -c "CREATE DATABASE laravel_livewire_app;"
   
   # Run migrations
   php artisan migrate
   ```

6. **Build assets**
   ```bash
   npm run build
   ```

## Database Configuration

The application is configured to use PostgreSQL by default. Update your `.env` file:

```env
DB_CONNECTION=pgsql
DB_HOST=127.0.0.1
DB_PORT=5432
DB_DATABASE=laravel_livewire_app
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

### PostgreSQL Features Used

- **JSONB** for flexible product attributes and order line attributes
- **CHECK constraints** for data validation (seasons, items, orders)
- **timestampTz** for timezone-aware timestamps
- **Advanced indexing** for optimal performance

## Development

### Starting the development server
```bash
php artisan serve
```
The application will be available at `http://localhost:8000`

### Building assets for production
```bash
npm run build
```

### Building assets in development mode
```bash
npm run dev
```

## Project Structure

```
laravel-livewire-app/
├── app/
│   ├── Http/
│   │   ├── Controllers/
│   │   └── Livewire/
│   └── Livewire/
├── resources/
│   ├── views/
│   │   ├── components/          # Blade components
│   │   ├── layouts/             # Layout templates
│   │   └── livewire/            # Livewire components
│   ├── css/
│   │   └── app.css              # Main CSS file with Bootstrap
│   └── js/
│       └── app.js               # Main JS file with Bootstrap
├── routes/
│   ├── web.php                  # Web routes
│   └── auth.php                 # Authentication routes
└── database/
    └── migrations/              # Database migrations
```

## Authentication

The application includes a complete authentication system with:

- User registration
- User login/logout
- Password reset
- Email verification
- Profile management

All authentication views are built with Livewire components and styled with Bootstrap.

## Customization

### Adding new Livewire components
```bash
php artisan make:livewire MyComponent
```

### Adding new routes
Edit `routes/web.php` for web routes or create new route files as needed.

### Styling
- Main styles are in `resources/css/app.css`
- Bootstrap is imported and can be customized
- Additional custom CSS can be added to the same file

## Available Routes

- `/` - Welcome page
- `/login` - Login page
- `/register` - Registration page
- `/dashboard` - Dashboard (requires authentication)
- `/profile` - User profile (requires authentication)
- `/forgot-password` - Password reset request
- `/reset-password/{token}` - Password reset form

### Test Routes (for development)
- `/test/seasons` - View all seasons with items
- `/test/categories` - View all categories with items
- `/test/items` - View all active items with relationships
- `/test/customers` - View all customers with addresses and orders
- `/test/orders` - View all orders with full relationships

## Database

The application uses PostgreSQL for robust, production-ready database operations. The database includes:

- **8 main tables** with proper relationships
- **PostgreSQL CHECK constraints** for data validation
- **JSONB fields** for flexible attribute storage
- **Strategic indexing** for optimal performance
- **Proper foreign key constraints** with cascade/restrict rules

### Key Tables
- `seasons` - Fashion seasons (AW/SS)
- `categories` - Product categories
- `items` - Main product catalog
- `colourways` - Product colour variants
- `customers` - Customer information
- `addresses` - Customer address book
- `orders` - Order management
- `order_lines` - Order line items

For detailed database schema information, see `DATABASE_SCHEMA.md`.

## Troubleshooting

### Common issues

1. **Assets not loading**: Run `npm run build` to compile assets
2. **Database errors**: Ensure PostgreSQL is running and database exists
3. **Livewire not working**: Check that Livewire is properly installed and configured
4. **PostgreSQL connection**: Verify database credentials and PostgreSQL service status

### PostgreSQL Service Management
```bash
# Start PostgreSQL service
brew services start postgresql@16

# Check service status
brew services list | grep postgresql

# Stop service
brew services stop postgresql@16
```

### Clearing caches
```bash
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear
```

## Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## License

This project is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
