# Laravel Livewire App with Bootstrap and Breeze

A modern Laravel application built with Livewire, Bootstrap 5, and Laravel Breeze for authentication.

## Features

- **Laravel 12** - Latest Laravel framework
- **Livewire 3** - Full-stack framework for Laravel
- **Bootstrap 5** - Latest Bootstrap CSS framework
- **Laravel Breeze** - Authentication scaffolding with Livewire stack
- **SQLite Database** - Lightweight database for development
- **Vite** - Modern frontend build tool

## Prerequisites

- PHP 8.2 or higher
- Composer
- Node.js and npm
- SQLite (or MySQL/PostgreSQL for production)

## Installation

1. **Clone the repository**
   ```bash
   git clone <your-repo-url>
   cd laravel-livewire-app
   ```

2. **Install PHP dependencies**
   ```bash
   composer install
   ```

3. **Install Node.js dependencies**
   ```bash
   npm install
   ```

4. **Environment setup**
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

5. **Database setup**
   ```bash
   php artisan migrate
   ```

6. **Build assets**
   ```bash
   npm run build
   ```

## Development

### Starting the development server
```bash
php artisan serve
```
The application will be available at `http://localhost:8000`

### Building assets for production
```bash
npm run build
```

### Building assets in development mode
```bash
npm run dev
```

## Project Structure

```
laravel-livewire-app/
├── app/
│   ├── Http/
│   │   ├── Controllers/
│   │   └── Livewire/
│   └── Livewire/
├── resources/
│   ├── views/
│   │   ├── components/          # Blade components
│   │   ├── layouts/             # Layout templates
│   │   └── livewire/            # Livewire components
│   ├── css/
│   │   └── app.css              # Main CSS file with Bootstrap
│   └── js/
│       └── app.js               # Main JS file with Bootstrap
├── routes/
│   ├── web.php                  # Web routes
│   └── auth.php                 # Authentication routes
└── database/
    └── migrations/              # Database migrations
```

## Authentication

The application includes a complete authentication system with:

- User registration
- User login/logout
- Password reset
- Email verification
- Profile management

All authentication views are built with Livewire components and styled with Bootstrap.

## Customization

### Adding new Livewire components
```bash
php artisan make:livewire MyComponent
```

### Adding new routes
Edit `routes/web.php` for web routes or create new route files as needed.

### Styling
- Main styles are in `resources/css/app.css`
- Bootstrap is imported and can be customized
- Additional custom CSS can be added to the same file

## Available Routes

- `/` - Welcome page
- `/login` - Login page
- `/register` - Registration page
- `/dashboard` - Dashboard (requires authentication)
- `/profile` - User profile (requires authentication)
- `/forgot-password` - Password reset request
- `/reset-password/{token}` - Password reset form

## Database

The application uses SQLite by default for development. The database file is located at `database/database.sqlite`.

For production, update your `.env` file to use MySQL or PostgreSQL:

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=your_database
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

## Troubleshooting

### Common issues

1. **Assets not loading**: Run `npm run build` to compile assets
2. **Database errors**: Ensure the database file exists and is writable
3. **Livewire not working**: Check that Livewire is properly installed and configured

### Clearing caches
```bash
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear
```

## Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## License

This project is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
