<?php

namespace App\Providers;

use App\Models\CustomRequest;
use App\Models\CustomSession;
use App\Policies\CustomRequestPolicy;
use App\Policies\CustomSessionPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        CustomRequest::class => CustomRequestPolicy::class,
        CustomSession::class => CustomSessionPolicy::class,
        User::class => AdminPolicy::class,
    ];

    public function boot(): void
    {
        $this->registerPolicies();
    }
}
