<?php

namespace Database\Seeders;

use App\Models\Season;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SeasonSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $seasons = [
            [
                'name' => 'Spring 2024',
                'slug' => 'spring-2024',
                'description' => 'Fresh spring collection with light colors and breathable fabrics.',
                'start_date' => '2024-03-01',
                'end_date' => '2024-05-31',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Summer 2024',
                'slug' => 'summer-2024',
                'description' => 'Hot summer styles perfect for warm weather and outdoor activities.',
                'start_date' => '2024-06-01',
                'end_date' => '2024-08-31',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Autumn 2024',
                'slug' => 'autumn-2024',
                'description' => 'Cozy autumn collection with warm tones and layered styles.',
                'start_date' => '2024-09-01',
                'end_date' => '2024-11-30',
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'Winter 2024',
                'slug' => 'winter-2024',
                'description' => 'Warm winter essentials for cold weather comfort.',
                'start_date' => '2024-12-01',
                'end_date' => '2025-02-28',
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'Holiday Special',
                'slug' => 'holiday-special',
                'description' => 'Special holiday collection with festive designs.',
                'start_date' => '2024-11-15',
                'end_date' => '2024-12-31',
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'Spring 2023',
                'slug' => 'spring-2023',
                'description' => 'Previous spring collection - now archived.',
                'start_date' => '2023-03-01',
                'end_date' => '2023-05-31',
                'is_active' => false,
                'sort_order' => 6,
            ],
        ];

        foreach ($seasons as $seasonData) {
            Season::updateOrCreate(
                ['slug' => $seasonData['slug']],
                $seasonData
            );
        }
    }
}
