<?php

namespace App\Http\Controllers;

use App\Contracts\PlaybackService;
use App\Http\Requests\PlaybackStoreRequest;

class PlaybackController extends Controller
{
    public function __construct(private readonly PlaybackService $playback)
    {
        $this->middleware('auth');
    }

    public function store(PlaybackStoreRequest $request)
    {
        $validated = $request->validated();
        $track = \App\Models\Track::findOrFail($validated['track_id']);
        $event = $this->playback->log($validated['event'], $request->user(), $track, $validated['at'] ?? null);
        return back()->with('status', 'Playback logged');
    }
}


