<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Statement extends Model
{
    use HasFactory;

    protected $fillable = [
        'cardholder_name',
        'masked_account_number',
        'statement_cycle',
        'period_start_date',
        'period_end_date',
        'currency',
        'status',
        'source_filename',
    ];

    protected $casts = [
        'period_start_date' => 'date',
        'period_end_date' => 'date',
    ];

    public function lines(): HasMany
    {
        return $this->hasMany(StatementLine::class);
    }
}
