<x-app-layout>
    <section class="py-4">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h4 mb-0">Categories</h1>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.categories.create') }}" class="btn btn-primary rounded-pill"><i class="bi bi-plus-lg me-1"></i> New Category</a>
                    <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-primary rounded-pill">Back to Dashboard</a>
                </div>
            </div>

            <div class="card shadow-sm">
                <div class="table-responsive">
                    <table class="table align-middle mb-0">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Slug</th>
                                <th>Sort</th>
                                <th>Items</th>
                                <th class="text-end">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($categories as $cat)
                                <tr>
                                    <td class="fw-semibold">{{ $cat->name }}</td>
                                    <td>{{ $cat->slug }}</td>
                                    <td>{{ $cat->sort_order }}</td>
                                    <td>{{ $cat->items()->count() }}</td>
                                    <td class="text-end">
                                        <a href="{{ route('admin.categories.edit', $cat) }}" class="btn btn-sm btn-outline-primary">Edit</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>


