<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('price_resolutions', function (Blueprint $table) {
            $table->id();

            // Identity keys for a resolution
            $table->unsignedBigInteger('style_versions_id')->index();
            $table->unsignedBigInteger('colourways_id')->index();
            $table->unsignedBigInteger('sizes_id')->nullable()->index();
            $table->unsignedBigInteger('phase_id')->nullable()->index();
            $table->unsignedBigInteger('season_id')->nullable()->index();

            // Invalidation keys - for fast cache clearing without joins
            $table->unsignedBigInteger('customer_id')->nullable()->index();
            $table->unsignedBigInteger('supplier_id')->nullable()->index(); // factory
            $table->unsignedBigInteger('style_id')->nullable()->index();
            $table->unsignedBigInteger('design_id')->nullable()->index();

            // The chosen price row (if applicable)
            $table->unsignedBigInteger('price_id')->nullable()->index();

            // Resolved numeric parts (store RAW numerics, not formatted strings)
            $table->decimal('cmt', 12, 4)->nullable();
            $table->decimal('cmt_base', 12, 4)->nullable();
            $table->decimal('quote', 12, 4)->nullable();
            $table->decimal('quote_base', 12, 4)->nullable();
            $table->decimal('discount_price', 12, 4)->nullable();
            $table->decimal('discount_price_base', 12, 4)->nullable();
            $table->decimal('gmt_trans_base', 12, 4)->nullable();
            $table->decimal('subtotal', 12, 4)->nullable();
            $table->decimal('subtotal_base', 12, 4)->nullable();
            $table->decimal('yarn_value_euro', 12, 4)->nullable();

            // Status and derived values
            $table->string('cmt_status', 32)->nullable();
            $table->string('quote_status', 32)->nullable();
            $table->decimal('margin', 6, 2)->nullable(); // percentage 0-100+

            // Currency snapshots
            $table->char('cust_currency', 3)->nullable();
            $table->char('fact_currency', 3)->nullable();

            // Freshness marker for tracing when the snapshot was last computed
            $table->timestamp('fresh_at')->nullable();

            // Ensure a single resolution per unique key combination
            $table->unique([
                'style_versions_id',
                'colourways_id',
                'sizes_id',
                'phase_id',
                'season_id',
            ], 'uq_price_resolutions');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('price_resolutions');
    }
};