<?php

namespace App\Livewire\Admin;

use App\Models\User;
use Livewire\Component;
use Livewire\WithPagination;

class Customers extends Component
{
    use WithPagination;
    
    public $search = '';
    public $perPage = 10;
    
    public function updatingSearch()
    {
        $this->resetPage();
    }
    
    public function viewCustomer($customerId)
    {
        return redirect()->route('admin.customers.show', $customerId);
    }
    
    public function render()
    {
        $customers = User::where('role', 'user')
            ->when($this->search, function ($query) {
                $query->where(function ($q) {
                    $q->where('name', 'like', '%' . $this->search . '%')
                      ->orWhere('email', 'like', '%' . $this->search . '%');
                });
            })
            ->orderBy('created_at', 'desc')
            ->paginate($this->perPage);
            
        return view('livewire.admin.customers', [
            'customers' => $customers
        ])
            ->layout('layouts.admin')
            ->title('Customers');
    }
}
