<?php

namespace App\Livewire\Admin;

use App\Models\User;
use Livewire\Component;
use Livewire\WithPagination;

class Customers extends Component
{
    use WithPagination;
    
    public $search = '';
    public $perPage = 10;
    
    public function updatingSearch()
    {
        $this->resetPage();
    }
    
    public function viewCustomer($customerId)
    {
        return redirect()->route('admin.customers.show', $customerId);
    }

    public function deleteCustomer($customerId)
    {
        $customer = User::findOrFail($customerId);
        
        // Check if customer has orders within the last 6 years
        $sixYearsAgo = now()->subYears(6);
        $recentOrders = $customer->orders()
            ->where('created_at', '>=', $sixYearsAgo)
            ->get();
        
        if ($recentOrders->count() > 0) {
            $oldestRecentOrder = $recentOrders->sortBy('created_at')->first();
            $orderDate = $oldestRecentOrder->created_at->format('M d, Y');
            
            session()->flash('error', "Cannot delete customer '{$customer->name}' because they have {$recentOrders->count()} order(s) within the last 6 years (oldest: {$orderDate}). Customer data must be retained for compliance.");
            return;
        }
        
        $customerName = $customer->name;
        $customer->delete();
        
        session()->flash('message', "Customer '{$customerName}' has been deleted successfully!");
    }
    
    public function render()
    {
        $customers = User::where('role', 'user')
            ->when($this->search, function ($query) {
                $query->where(function ($q) {
                    $q->where('name', 'like', '%' . $this->search . '%')
                      ->orWhere('email', 'like', '%' . $this->search . '%');
                });
            })
            ->orderBy('created_at', 'desc')
            ->paginate($this->perPage);
            
        return view('livewire.admin.customers', [
            'customers' => $customers
        ])
            ->layout('layouts.admin')
            ->title('Customers');
    }
}
