<?php

namespace App\Livewire\Manage;

use Livewire\Component;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rules\File;
use Illuminate\Support\Facades\Storage;
use App\Models\Receipt;
use App\Models\ReceiptLine;
use App\Services\ReceiptProcessingService;

class ReceiptBulkUpload extends Component
{
    use WithFileUploads;

    public array $files = [];

    protected function rules(): array
    {
        return [
            'files.*' => [File::image()->max('10mb')],
        ];
    }

    public function updatedFiles()
    {
        $this->validateOnly('files.*');
    }

    public function upload(ReceiptProcessingService $processingService)
    {
        $this->validate();
        $disk = config('filesystems.default');
        foreach ($this->files as $upload) {
            $path = $upload->store('receipts', $disk);
            $hash = hash_file('sha256', Storage::disk($disk)->path($path));

            $receipt = Receipt::create([
                'user_id' => auth()->id(),
                'receipt_date' => now()->toDateString(),
                'total_amount' => 0,
                'currency' => 'GBP',
                'image_disk' => $disk,
                'image_path' => $path,
                'image_hash' => $hash,
            ]);

            $processingService->process($receipt);
        }

        $this->reset('files');
        session()->flash('status', 'Receipts uploaded. Processing will continue in background.');
    }

    public function render()
    {
        return view('livewire.manage.receipt-bulk-upload');
    }
}


