<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-2">
                    <li class="breadcrumb-item">
                        <a href="{{ route('admin.customers') }}" class="text-decoration-none">Customers</a>
                    </li>
                    <li class="breadcrumb-item active">{{ $customer->name }}</li>
                </ol>
            </nav>
            <h1 class="h3 mb-1">Customer Details</h1>
            <p class="text-muted mb-0">View and manage customer information and order history</p>
        </div>
        <div class="btn-group">
            @if($editing)
                <button wire:click="save" class="btn btn-success">
                    <i class="bi bi-check-lg me-2"></i>Save Changes
                </button>
                <button wire:click="cancel" class="btn btn-outline-secondary">
                    <i class="bi bi-x-lg me-2"></i>Cancel
                </button>
            @else
                <button wire:click="toggleEdit" class="btn btn-primary">
                    <i class="bi bi-pencil me-2"></i>Edit Customer
                </button>
            @endif
        </div>
    </div>

    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <!-- Customer Information -->
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-person me-2"></i>Customer Information
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Basic Information -->
                    <div class="row g-4 mb-4">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-person-circle text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0">Full Name</label>
                            </div>
                            @if($editing)
                                <input type="text" 
                                       wire:model="name" 
                                       class="form-control @error('name') is-invalid @enderror">
                                @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="fs-5 fw-medium text-body">{{ $customer->name }}</div>
                            @endif
                        </div>
                        
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-envelope text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0">Email Address</label>
                            </div>
                            @if($editing)
                                <input type="email" 
                                       wire:model="email" 
                                       class="form-control @error('email') is-invalid @enderror">
                                @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="d-flex align-items-center">
                                    <div class="fs-5 fw-medium text-body me-2">{{ $customer->email }}</div>
                                    @if($customer->email_verified_at)
                                        <span class="badge bg-success">
                                            <i class="bi bi-check-circle me-1"></i>Verified
                                        </span>
                                    @else
                                        <span class="badge bg-warning">
                                            <i class="bi bi-exclamation-circle me-1"></i>Unverified
                                        </span>
                                    @endif
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Account Details -->
                    <div class="border-top pt-4 mb-4">
                        <h6 class="text-muted text-uppercase fw-semibold mb-3">
                            <i class="bi bi-gear me-2"></i>Account Details
                        </h6>
                        <div class="row g-4">
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-shield-check text-primary me-2"></i>
                                    <label class="form-label fw-semibold mb-0">Role</label>
                                </div>
                                @if($editing)
                                    <select wire:model="role" class="form-select @error('role') is-invalid @enderror">
                                        <option value="user">User</option>
                                        <option value="admin">Admin</option>
                                    </select>
                                    @error('role') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                    <span class="badge bg-{{ $customer->role === 'admin' ? 'primary' : 'secondary' }} fs-6">
                                        <i class="bi bi-{{ $customer->role === 'admin' ? 'shield-check' : 'person' }} me-1"></i>
                                        {{ ucfirst($customer->role) }}
                                    </span>
                                @endif
                            </div>
                            
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-hash text-primary me-2"></i>
                                    <label class="form-label fw-semibold mb-0">Customer ID</label>
                                </div>
                                <div class="fs-5 fw-medium text-body">#{{ $customer->id }}</div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-envelope-check text-primary me-2"></i>
                                    <label class="form-label fw-semibold mb-0">Marketing Consent</label>
                                </div>
                                @if($editing)
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               wire:model="marketingConsent" 
                                               class="form-check-input @error('marketingConsent') is-invalid @enderror" 
                                               id="marketingConsent">
                                        <label class="form-check-label" for="marketingConsent">
                                            Customer has agreed to receive marketing emails
                                        </label>
                                    </div>
                                    @error('marketingConsent') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                    @if($customer->hasMarketingConsent())
                                        <div class="d-flex align-items-center">
                                            <span class="badge bg-success me-2">
                                                <i class="bi bi-check-circle me-1"></i>Consented
                                            </span>
                                        </div>
                                        <small class="text-muted">
                                            Agreed on {{ $customer->marketing_consent_at->format('F j, Y') }}
                                        </small>
                                    @else
                                        <span class="badge bg-secondary">
                                            <i class="bi bi-x-circle me-1"></i>No Consent
                                        </span>
                                    @endif
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Account Timeline -->
                    <div class="border-top pt-4">
                        <h6 class="text-muted text-uppercase fw-semibold mb-3">
                            <i class="bi bi-clock-history me-2"></i>Account Timeline
                        </h6>
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-calendar-plus text-primary me-2"></i>
                                    <label class="form-label fw-semibold mb-0">Member Since</label>
                                </div>
                                <div class="fs-5 fw-medium text-body">{{ $customer->created_at->format('F j, Y') }}</div>
                                <small class="text-muted">{{ $customer->created_at->diffForHumans() }}</small>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-calendar-check text-primary me-2"></i>
                                    <label class="form-label fw-semibold mb-0">Last Updated</label>
                                </div>
                                <div class="fs-5 fw-medium text-body">{{ $customer->updated_at->format('F j, Y') }}</div>
                                <small class="text-muted">{{ $customer->updated_at->diffForHumans() }}</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Customer Stats -->
        <div class="col-lg-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-graph-up me-2"></i>Customer Stats
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-12">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <div class="text-muted small">Total Orders</div>
                                    <div class="h4 mb-0">{{ $orders->count() }}</div>
                                </div>
                                <i class="bi bi-cart-check text-primary fs-2"></i>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <div class="text-muted small">Total Spent</div>
                                    <div class="h4 mb-0">$0.00</div>
                                </div>
                                <i class="bi bi-currency-dollar text-success fs-2"></i>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <div class="text-muted small">Average Order</div>
                                    <div class="h4 mb-0">$0.00</div>
                                </div>
                                <i class="bi bi-graph-up text-info fs-2"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Addresses Section -->
    <div class="card mb-4">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="bi bi-geo-alt me-2"></i>Addresses
                </h5>
                <button wire:click="showAddAddressForm" class="btn btn-primary btn-sm">
                    <i class="bi bi-plus-lg me-2"></i>Add Address
                </button>
            </div>
        </div>
        <div class="card-body">
            @if($showAddressForm)
                <!-- Address Form -->
                <div class="card border-primary mb-4">
                    <div class="card-header bg-primary text-white">
                        <h6 class="mb-0">
                            <i class="bi bi-{{ $editingAddress ? 'pencil' : 'plus' }} me-2"></i>
                            {{ $editingAddress ? 'Edit Address' : 'Add New Address' }}
                        </h6>
                    </div>
                    <div class="card-body">
                        <form wire:submit.prevent="saveAddress">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Address Type</label>
                                    <select wire:model="addressType" class="form-select @error('addressType') is-invalid @enderror">
                                        <option value="shipping">Shipping Address</option>
                                        <option value="billing">Billing Address</option>
                                        <option value="both">Both</option>
                                    </select>
                                    @error('addressType') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-check mt-4">
                                        <input type="checkbox" wire:model="isDefault" class="form-check-input" id="isDefault">
                                        <label class="form-check-label" for="isDefault">
                                            Set as default address
                                        </label>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">First Name</label>
                                    <input type="text" wire:model="firstName" 
                                           class="form-control @error('firstName') is-invalid @enderror">
                                    @error('firstName') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Last Name</label>
                                    <input type="text" wire:model="lastName" 
                                           class="form-control @error('lastName') is-invalid @enderror">
                                    @error('lastName') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                
                                <div class="col-12">
                                    <label class="form-label">Company (Optional)</label>
                                    <input type="text" wire:model="company" 
                                           class="form-control @error('company') is-invalid @enderror">
                                    @error('company') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                
                                <div class="col-12">
                                    <label class="form-label">Address Line 1</label>
                                    <input type="text" wire:model="addressLine1" 
                                           class="form-control @error('addressLine1') is-invalid @enderror" 
                                           placeholder="Street address, P.O. box, company name, c/o">
                                    @error('addressLine1') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                
                                <div class="col-12">
                                    <label class="form-label">Address Line 2</label>
                                    <input type="text" wire:model="addressLine2" 
                                           class="form-control @error('addressLine2') is-invalid @enderror" 
                                           placeholder="Apartment, suite, unit, building, floor, etc.">
                                    @error('addressLine2') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                
                                <div class="col-md-4">
                                    <label class="form-label">City</label>
                                    <input type="text" wire:model="city" 
                                           class="form-control @error('city') is-invalid @enderror">
                                    @error('city') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                
                                <div class="col-md-4">
                                    <label class="form-label">State/Province</label>
                                    <input type="text" wire:model="stateProvince" 
                                           class="form-control @error('stateProvince') is-invalid @enderror">
                                    @error('stateProvince') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                
                                <div class="col-md-4">
                                    <label class="form-label">Postal Code</label>
                                    <input type="text" wire:model="postalCode" 
                                           class="form-control @error('postalCode') is-invalid @enderror">
                                    @error('postalCode') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Country</label>
                                    <input type="text" wire:model="country" 
                                           class="form-control @error('country') is-invalid @enderror">
                                    @error('country') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Phone (Optional)</label>
                                    <input type="text" wire:model="phone" 
                                           class="form-control @error('phone') is-invalid @enderror">
                                    @error('phone') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                </div>
                                
                                <div class="col-12">
                                    <div class="d-flex gap-2">
                                        <button type="submit" class="btn btn-success">
                                            <i class="bi bi-check-lg me-2"></i>Save Address
                                        </button>
                                        <button type="button" wire:click="cancelAddressForm" class="btn btn-outline-secondary">
                                            <i class="bi bi-x-lg me-2"></i>Cancel
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            @endif
            
            @if($addresses->count() > 0)
                <!-- Addresses List -->
                <div class="row g-3">
                    @foreach($addresses->sortByDesc('is_default') as $address)
                        <div class="col-md-6">
                            <div class="card {{ $address->is_default ? 'border-primary' : 'border' }}">
                                @if($address->is_default)
                                    <div class="card-header bg-primary text-white py-1 px-3">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center">
                                                <i class="bi bi-star-fill me-2"></i>
                                                <span class="fw-semibold">Default {{ ucfirst($address->type) }} Address</span>
                                            </div>
                                            <div class="btn-group btn-group-sm">
                                                <button wire:click="editAddress({{ $address->id }})" 
                                                        class="btn btn-outline-light btn-sm">
                                                    <i class="bi bi-pencil"></i>
                                                </button>
                                                <button wire:click="deleteAddress({{ $address->id }})" 
                                                        class="btn btn-outline-light btn-sm"
                                                        onclick="return confirm('Are you sure you want to delete this address?')">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                @else
                                    <div class="card-header bg-body-secondary py-1 px-3">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center">
                                                <i class="bi bi-geo-alt me-2"></i>
                                                <span class="fw-semibold">{{ ucfirst($address->type) }} Address</span>
                                            </div>
                                            <div class="btn-group btn-group-sm">
                                                <button wire:click="editAddress({{ $address->id }})" 
                                                        class="btn btn-outline-primary btn-sm">
                                                    <i class="bi bi-pencil"></i>
                                                </button>
                                                <button wire:click="deleteAddress({{ $address->id }})" 
                                                        class="btn btn-outline-danger btn-sm"
                                                        onclick="return confirm('Are you sure you want to delete this address?')">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="card-body {{ $address->is_default ? 'bg-primary bg-opacity-10' : '' }}">
                                    
                                    <div class="{{ $address->is_default ? 'text-body' : 'text-muted' }} small">
                                        <div class="fw-semibold">{{ $address->first_name }} {{ $address->last_name }}</div>
                                        @if($address->company)
                                            <div>{{ $address->company }}</div>
                                        @endif
                                        <div>{{ $address->address_line_1 }}</div>
                                        @if($address->address_line_2)
                                            <div>{{ $address->address_line_2 }}</div>
                                        @endif
                                        <div>{{ $address->city }}, {{ $address->state_province }} {{ $address->postal_code }}</div>
                                        <div>{{ $address->country }}</div>
                                        @if($address->phone)
                                            <div class="mt-1">
                                                <i class="bi bi-telephone me-1"></i>{{ $address->phone }}
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <!-- Empty Addresses State -->
                <div class="text-center py-4">
                    <i class="bi bi-geo-alt display-4 text-muted"></i>
                    <h5 class="mt-3">No addresses found</h5>
                    <p class="text-muted">This customer hasn't added any addresses yet.</p>
                    <button wire:click="showAddAddressForm" class="btn btn-primary">
                        <i class="bi bi-plus-lg me-2"></i>Add First Address
                    </button>
                </div>
            @endif
        </div>
    </div>

    <!-- Orders Section -->
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="bi bi-list-ul me-2"></i>Order History
                </h5>
                <div class="d-flex align-items-center gap-2">
                    <label class="form-label mb-0 small">Per page:</label>
                    <select wire:model.live="ordersPerPage" class="form-select form-select-sm" style="width: auto;">
                        <option value="5">5</option>
                        <option value="10">10</option>
                        <option value="25">25</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            @if($orders->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0">Order #</th>
                                <th class="border-0">Date</th>
                                <th class="border-0">Status</th>
                                <th class="border-0">Items</th>
                                <th class="border-0">Total</th>
                                <th class="border-0 text-end">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orders as $order)
                                <tr>
                                    <td>
                                        <div class="fw-semibold">#{{ $order->id }}</div>
                                        <small class="text-muted">{{ $order->order_number ?? 'N/A' }}</small>
                                    </td>
                                    <td>
                                        <div>{{ $order->created_at->format('M j, Y') }}</div>
                                        <small class="text-muted">{{ $order->created_at->format('g:i A') }}</small>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary">{{ ucfirst($order->status ?? 'pending') }}</span>
                                    </td>
                                    <td>
                                        <div>{{ $order->orderLines->count() }} item(s)</div>
                                        @if($order->orderLines->count() > 0)
                                            <small class="text-muted">
                                                {{ $order->orderLines->first()->item->name ?? 'Unknown Item' }}
                                                @if($order->orderLines->count() > 1)
                                                    +{{ $order->orderLines->count() - 1 }} more
                                                @endif
                                            </small>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="fw-semibold">${{ number_format($order->total_amount ?? 0, 2) }}</div>
                                    </td>
                                    <td class="text-end">
                                        <button class="btn btn-outline-primary btn-sm">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Orders Pagination - TODO: Add when Order model is implemented -->
            @else
                <!-- Empty Orders State -->
                <div class="text-center py-5">
                    <i class="bi bi-cart-x display-1 text-muted"></i>
                    <h4 class="mt-3">No orders found</h4>
                    <p class="text-muted">This customer hasn't placed any orders yet.</p>
                </div>
            @endif
        </div>
    </div>
</div>
