<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Track extends Model
{
    use HasFactory;

    public $incrementing = false;

    protected $keyType = 'string';

    protected $fillable = [
        'id',
        'title',
        'description',
        'image_url',
        'duration_sec',
        'level',
        'voice_actor_id',
        'audio_url',
        'transcript_url',
        'published_at',
    ];

    protected $casts = [
        'published_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function voiceActor()
    {
        return $this->belongsTo(VoiceActor::class);
    }

    public function tags()
    {
        return $this->belongsToMany(Tag::class, 'track_tags');
    }
}


