<?php

namespace App\Http\Controllers\Api\V1;

use App\Contracts\LibraryService;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class TracksController extends Controller
{
    public function __construct(private readonly LibraryService $library)
    {
        $this->middleware(['auth:sanctum']);
    }

    public function index(Request $request)
    {
        $tags = $request->query('tags');
        $tagSlugs = is_string($tags) ? array_filter(array_map('trim', explode(',', $tags))) : null;
        $level = $request->query('level');
        $perPage = (int) ($request->query('per_page', 50));
        $tracks = $this->library->listTracks($tagSlugs, $level, $perPage);

        return response()->json($tracks);
    }
}


