<?php

namespace App\Http\Controllers\Api\V1;

use App\Contracts\LibraryService;
use App\Http\Controllers\Controller;
use App\Models\Track;
use Illuminate\Http\Request;

class TracksController extends Controller
{
    public function __construct(private readonly LibraryService $library)
    {
        // auth middleware applied at route level
    }

    public function index(Request $request)
    {
        $q = $request->string('q')->toString() ?: null;
        $tagIds = $request->input('tag_ids');
        $tagSlugs = null;
        if (is_array($tagIds) && !empty($tagIds)) {
            $tagSlugs = \App\Models\Tag::whereIn('id', $tagIds)->pluck('slug')->all();
        }
        $level = $request->string('level')->toString() ?: null;
        $perPage = (int) $request->integer('per_page', 50);

        $tracks = $this->library->listTracks($tagSlugs, $level, $perPage, $q);
        return response()->json($tracks);
    }

    public function show(string $id)
    {
        $track = Track::with(['voiceActor', 'tags'])->findOrFail($id);
        return response()->json($track);
    }
}


