<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Receipt extends Model
{
    protected $fillable = [
        'user_id',
        'receipt_date',
        'merchant_name',
        'total_amount',
        'currency',
        'image_disk',
        'image_path',
        'image_hash',
        'department_id',
        'account_id',
        'receipt_group_id',
        'is_personal',
        'meta',
    ];

    protected $casts = [
        'receipt_date' => 'date',
        'is_personal' => 'boolean',
        'meta' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function department(): BelongsTo
    {
        return $this->belongsTo(Department::class);
    }

    public function account(): BelongsTo
    {
        return $this->belongsTo(Account::class);
    }

    public function lines(): HasMany
    {
        return $this->hasMany(ReceiptLine::class);
    }

    public function matches(): HasMany
    {
        return $this->hasMany(TransactionMatch::class);
    }
}
