<?php
$meta = [
  'title' => 'Contact | Get a free quote',
  'description' => 'Let\'s get your project moving. Short, friendly form for a fast, fixed quote.',
  'canonical' => 'https://neilwiddowson.co.uk/contact/'
];
$currentPage = 'contact';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-2xl">
    <div class="text-center mb-8">
      <h1 class="text-4xl sm:text-5xl font-bold tracking-tight text-gray-900">
        Let's get your project <span class="accent-underline">moving</span>.
      </h1>
      <p class="mt-4 text-lg text-gray-700">
        Tell me what you need and I'll get back to you within 24 hours with a clear, honest quote.
      </p>
    </div>

    <div class="grid gap-8 lg:grid-cols-2 lg:items-start">
      <!-- Contact Form -->
      <div class="card p-6">
        <form action="/contact/contact.php" method="post" data-validate="true" novalidate class="space-y-4">
          <div>
            <label class="block text-sm font-medium text-gray-900 mb-2" for="name">Your name *</label>
            <input class="w-full px-4 py-3 rounded-xl border border-gray-300 focus:border-accent-500 focus:ring-2 focus:ring-accent-500/20 transition-colors" 
                   id="name" name="name" type="text" required data-required 
                   placeholder="John Smith">
          </div>
          
          <div>
            <label class="block text-sm font-medium text-gray-900 mb-2" for="email">Email address *</label>
            <input class="w-full px-4 py-3 rounded-xl border border-gray-300 focus:border-accent-500 focus:ring-2 focus:ring-accent-500/20 transition-colors" 
                   id="email" name="email" type="email" required data-required 
                   placeholder="john@example.com">
          </div>
          
          <div>
            <label class="block text-sm font-medium text-gray-900 mb-2" for="phone">Phone (optional)</label>
            <input class="w-full px-4 py-3 rounded-xl border border-gray-300 focus:border-accent-500 focus:ring-2 focus:ring-accent-500/20 transition-colors" 
                   id="phone" name="phone" type="tel" inputmode="tel" 
                   placeholder="0191 123 4567">
          </div>
          
          <div>
            <label class="block text-sm font-medium text-gray-900 mb-2" for="business">Business name *</label>
            <input class="w-full px-4 py-3 rounded-xl border border-gray-300 focus:border-accent-500 focus:ring-2 focus:ring-accent-500/20 transition-colors" 
                   id="business" name="business" type="text" required data-required 
                   placeholder="Your Business Ltd">
          </div>
          
          <div>
            <label class="block text-sm font-medium text-gray-900 mb-2" for="needs">What do you need help with? *</label>
            <select class="w-full px-4 py-3 rounded-xl border border-gray-300 focus:border-accent-500 focus:ring-2 focus:ring-accent-500/20 transition-colors" 
                    id="needs" name="needs" required data-required>
              <option value="">Choose what you need...</option>
              <option value="Website design">Website design</option>
              <option value="IT support">IT support</option>
              <option value="Website care">Website care & hosting</option>
              <option value="Software development">Custom software & AI</option>
              <option value="SEO">SEO & content</option>
              <option value="Bitdefender">Bitdefender security</option>
              <option value="Other">Something else</option>
            </select>
          </div>
          
          <div>
            <label class="block text-sm font-medium text-gray-900 mb-2" for="message">Tell me about your project *</label>
            <textarea class="w-full px-4 py-3 rounded-xl border border-gray-300 focus:border-accent-500 focus:ring-2 focus:ring-accent-500/20 transition-colors resize-none" 
                      id="message" name="message" rows="4" required data-required 
                      placeholder="What's your current situation and what would you like to achieve?"></textarea>
          </div>

          <!-- Honeypot -->
          <div class="visually-hidden" aria-hidden="true">
            <label for="company">Company</label>
            <input id="company" name="company" type="text" tabindex="-1" autocomplete="off">
          </div>

          <!-- Consent -->
          <div class="flex items-start gap-3 pt-2">
            <input id="consent" name="consent" type="checkbox" 
                   class="mt-1 h-5 w-5 rounded border-gray-300 text-accent-600 focus:ring-accent-500" 
                   value="yes" required data-required>
            <label for="consent" class="text-sm text-gray-700">
              I consent to my details being used to respond to this enquiry. 
              <a class="underline hover:no-underline text-accent-600" href="/privacy/">Privacy policy</a>.
            </label>
          </div>

          <button class="w-full btn-primary py-4 text-lg font-semibold" type="submit">
            Get my free quote
          </button>
        </form>
      </div>

      <!-- Contact Info & Quick Actions -->
      <div class="space-y-6">
        <div class="card p-6">
          <h3 class="text-lg font-semibold text-gray-900 mb-4">Quick contact</h3>
          <div class="space-y-3">
            <a href="mailto:hello@neilwiddowson.co.uk" class="flex items-center gap-3 text-gray-700 hover:text-accent-600 transition-colors">
              <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"></path>
                <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"></path>
              </svg>
              hello@neilwiddowson.co.uk
            </a>
            <a href="tel:01911234567" class="flex items-center gap-3 text-gray-700 hover:text-accent-600 transition-colors">
              <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"></path>
              </svg>
              0191 123 4567
            </a>
          </div>
        </div>

        <div class="card p-6">
          <h3 class="text-lg font-semibold text-gray-900 mb-4">What happens next?</h3>
          <div class="space-y-3 text-sm text-gray-700">
            <div class="flex items-start gap-3">
              <div class="w-6 h-6 bg-accent-100 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5">
                <span class="text-xs font-semibold text-accent-600">1</span>
              </div>
              <p>I'll read your message and get back to you within 24 hours</p>
            </div>
            <div class="flex items-start gap-3">
              <div class="w-6 h-6 bg-accent-100 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5">
                <span class="text-xs font-semibold text-accent-600">2</span>
              </div>
              <p>We'll have a quick chat to understand your needs better</p>
            </div>
            <div class="flex items-start gap-3">
              <div class="w-6 h-6 bg-accent-100 rounded-full flex items-center justify-center flex-shrink-0 mt-0.5">
                <span class="text-xs font-semibold text-accent-600">3</span>
              </div>
              <p>I'll give you a clear, honest quote with no surprises</p>
            </div>
          </div>
        </div>

        <div class="card p-6 bg-accent-50">
          <h3 class="text-lg font-semibold text-gray-900 mb-2">Free website checkup</h3>
          <p class="text-sm text-gray-700 mb-4">Get a free 15-minute review of your current website or IT setup.</p>
          <a href="/contact/#checkup" class="btn-secondary w-full text-center">Book free checkup</a>
        </div>
      </div>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
