<?php
$meta = [
  'title' => 'Contact | Get a free quote',
  'description' => 'Let\'s get your project moving. Short, friendly form for a fast, fixed quote.',
  'canonical' => 'https://neilwiddowson.co.uk/contact/'
];
$currentPage = 'contact';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-2xl">
    <div class="text-center mb-8">
      <h1 class="text-4xl sm:text-5xl font-bold tracking-tight text-gray-900">
        Let's get your project <span class="accent-underline">moving</span>.
      </h1>
      <p class="mt-4 text-lg text-gray-700">
        Tell me what you need and I'll get back to you within 24 hours with a clear, honest quote.
      </p>
    </div>

    <div class="max-w-lg mx-auto">
      <!-- Contact Form -->
      <div class="bg-white rounded-xl shadow-lg border border-gray-200" style="margin: 32px; padding: 32px;">
          <form action="/contact/contact.php" method="post" data-validate="true" novalidate class="space-y-6">
            <div>
              <label class="block text-sm font-medium text-gray-900 mb-2" for="name">Name *</label>
              <input class="w-full px-4 p-3 rounded-xl border border-gray-300 focus:border-accent-500 focus:ring-2 focus:ring-accent-500/20 transition-colors" 
                     id="name" name="name" type="text" required data-required 
                     placeholder="John Smith">
            </div>
            
            <div>
              <label class="block text-sm font-medium text-gray-900 mb-2" for="email">Email *</label>
              <input class="w-full px-4 p-3 rounded-xl border border-gray-300 focus:border-accent-500 focus:ring-2 focus:ring-accent-500/20 transition-colors" 
                     id="email" name="email" type="email" required data-required 
                     placeholder="john@example.com">
            </div>
            
            <div>
              <label class="block text-sm font-medium text-gray-900 mb-2" for="company">Company *</label>
              <input class="w-full px-4 p-3 rounded-xl border border-gray-300 focus:border-accent-500 focus:ring-2 focus:ring-accent-500/20 transition-colors" 
                     id="company" name="company" type="text" required data-required 
                     placeholder="Your Business Ltd">
            </div>
            
            <div>
              <label class="block text-sm font-medium text-gray-900 mb-2" for="message">Message *</label>
              <textarea class="w-full p-3 rounded-xl border border-gray-300 focus:border-accent-500 focus:ring-2 focus:ring-accent-500/20 transition-colors resize-none" 
                        id="message" name="message" rows="5" required data-required 
                        placeholder="What do you need help with?"></textarea>
            </div>

            <!-- Honeypot -->
            <div class="visually-hidden" aria-hidden="true">
              <label for="website">Website</label>
              <input id="website" name="website" type="text" tabindex="-1" autocomplete="off">
            </div>

            <button class="w-full btn-primary py-4 text-lg font-semibold" type="submit">
              Send message
            </button>
          </form>
        </div>
      </div>

      <!-- Contact Info -->
      <div class="mt-8 text-center">
        <div class="bg-white rounded-xl shadow-lg border border-gray-200" style="padding: 24px;">
          <h3 class="text-lg font-semibold text-gray-900 mb-4">Or get in touch directly</h3>
          <div class="space-y-3">
            <a href="mailto:neil@neilwiddowson.co.uk" class="flex items-center justify-center gap-3 text-gray-700 hover:text-accent-600 transition-colors">
              <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"></path>
                <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"></path>
              </svg>
              neil@neilwiddowson.co.uk
            </a>
            <a href="tel:07565659199" class="flex items-center justify-center gap-3 text-gray-700 hover:text-accent-600 transition-colors">
              <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"></path>
              </svg>
              07565 659 199
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
