<?php
$meta = [
  'title' => 'Contact | Get a free quote',
  'description' => 'Let\'s get your project moving. Short, friendly form for a fast, fixed quote.',
  'canonical' => 'https://neilwiddowson.co.uk/contact/'
];
$currentPage = 'contact';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-3xl">
    <h1 class="text-3xl font-bold tracking-tight">Let's get your project moving.</h1>
    <form class="mt-6 card p-6 space-y-5" action="/contact/contact.php" method="post" data-validate="true" novalidate>
      <div>
        <label class="block text-sm font-medium text-gray-900" for="name">Name</label>
        <input class="mt-1 w-full rounded-xl border-gray-300 focus:border-accent-500 focus:ring-accent-500" id="name" name="name" type="text" required data-required>
      </div>
      <div>
        <label class="block text-sm font-medium text-gray-900" for="email">Email</label>
        <input class="mt-1 w-full rounded-xl border-gray-300 focus:border-accent-500 focus:ring-accent-500" id="email" name="email" type="email" required data-required>
      </div>
      <div>
        <label class="block text-sm font-medium text-gray-900" for="phone">Phone (optional)</label>
        <input class="mt-1 w-full rounded-xl border-gray-300 focus:border-accent-500 focus:ring-accent-500" id="phone" name="phone" type="tel" inputmode="tel">
      </div>
      <div>
        <label class="block text-sm font-medium text-gray-900" for="business">Business name</label>
        <input class="mt-1 w-full rounded-xl border-gray-300 focus:border-accent-500 focus:ring-accent-500" id="business" name="business" type="text" required data-required>
      </div>
      <div>
        <label class="block text-sm font-medium text-gray-900" for="needs">What you need</label>
        <select class="mt-1 w-full rounded-xl border-gray-300 focus:border-accent-500 focus:ring-accent-500" id="needs" name="needs[]" multiple size="4" required data-required>
          <option>Website design</option>
          <option>IT support</option>
          <option>SEO & content</option>
          <option>Website care</option>
        </select>
        <p class="mt-1 text-xs text-gray-500">Hold Cmd/Ctrl to select more than one.</p>
      </div>
      <div>
        <label class="block text-sm font-medium text-gray-900" for="message">Message</label>
        <textarea class="mt-1 w-full rounded-xl border-gray-300 focus:border-accent-500 focus:ring-accent-500" id="message" name="message" rows="5" required data-required></textarea>
      </div>

      <!-- Honeypot -->
      <div class="visually-hidden" aria-hidden="true">
        <label for="company">Company</label>
        <input id="company" name="company" type="text" tabindex="-1" autocomplete="off">
      </div>

      <!-- Simple math challenge -->
      <div>
        <label class="block text-sm font-medium text-gray-900" for="math">What is 5 + 3?</label>
        <input class="mt-1 w-full rounded-xl border-gray-300 focus:border-accent-500 focus:ring-accent-500" id="math" name="math" type="number" inputmode="numeric" required data-required>
      </div>

      <!-- Consent -->
      <div class="flex items-start gap-3">
        <input id="consent" name="consent" type="checkbox" class="mt-1 h-5 w-5 rounded border-gray-300 text-accent-600 focus:ring-accent-500" value="yes" required data-required>
        <label for="consent" class="text-sm text-gray-700">I consent to my details being used to respond to this enquiry. <a class="underline hover:no-underline" href="/privacy/">Privacy</a>.</label>
      </div>

      <div class="flex items-center gap-3">
        <button class="btn-primary" type="submit">Get a free quote</button>
        <a class="btn-secondary" id="checkup" href="/contact/">Free website/IT checkup</a>
      </div>
    </form>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
