<?php

namespace App\Jobs;

use App\Models\ReceiptLine;
use App\Services\Matching\ClassificationService;
use App\Services\VAT\UkVatService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessReceiptLine implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 2;
    public int $timeout = 30; // Reduced timeout for individual line processing
    public int $maxExceptions = 1;

    public function __construct(public int $lineId) {}

    public function handle(ClassificationService $classification, UkVatService $vat): void
    {
        $line = ReceiptLine::find($this->lineId);
        if (!$line) {
            return;
        }

        // Process classification and VAT analysis
        $classification->classifyReceiptLine($line);
        $vat->analyzeLine($line);
    }
}
