<div>
    <div class="card border-0 shadow-sm h-100 w-100">
        <div class="card-header bg-gradient bg-primary text-white border-0">
            <div class="d-flex align-items-center">
                <div class="bg-white bg-opacity-20 rounded-circle p-2 me-3">
                    <i class="fas fa-chart-bar fs-5"></i>
                </div>
                <div>
                    <h5 class="card-title mb-1 fw-bold">Garments Due to Ship</h5>
                    <small class="text-white-75">Monthly view - 3 years history</small>
                </div>
            </div>
        </div>
        <div class="card-body">
            @if($isLoading)
                <div class="d-flex justify-content-center align-items-center" style="height: 300px;">
                    <div class="text-center">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <p class="mt-2 text-muted">Loading chart data...</p>
                    </div>
                </div>
            @else
                <div class="position-relative" style="height: 300px;">
                    <canvas id="garmentsDueChart"></canvas>
                </div>
                
                <!-- Debug info -->
                <div class="mt-2">
                    <small class="text-muted">
                        Data points: {{ count($chartData['labels'] ?? []) }} months, 
                        Datasets: {{ count($chartData['datasets'] ?? []) }} years
                    </small>
                </div>
            @endif
        </div>
    </div>

    @if(!$isLoading)
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                // Wait for Livewire to load
                document.addEventListener('livewire:load', function () {
                    initChart();
                });
                
                // Also try to init if Livewire is already loaded
                if (window.Livewire) {
                    initChart();
                }
            });

            function initChart() {
                const canvas = document.getElementById('garmentsDueChart');
                if (!canvas) return;
                
                const ctx = canvas.getContext('2d');
                
                // Destroy existing chart if it exists
                if (window.garmentsChart) {
                    window.garmentsChart.destroy();
                }
                
                const chartData = @json($chartData);
                
                console.log('Chart data:', chartData); // Debug log
                
                window.garmentsChart = new Chart(ctx, {
                    type: 'line',
                    data: chartData,
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        interaction: {
                            intersect: false,
                            mode: 'index'
                        },
                        plugins: {
                            legend: {
                                position: 'top',
                                labels: {
                                    usePointStyle: true,
                                    padding: 20
                                }
                            },
                            tooltip: {
                                callbacks: {
                                    label: function(context) {
                                        return context.dataset.label + ': ' + context.parsed.y.toLocaleString() + ' garments';
                                    }
                                }
                            }
                        },
                        scales: {
                            x: {
                                display: true,
                                title: {
                                    display: true,
                                    text: 'Month'
                                },
                                grid: {
                                    display: false
                                }
                            },
                            y: {
                                display: true,
                                title: {
                                    display: true,
                                    text: 'Garments Due'
                                },
                                beginAtZero: true,
                                ticks: {
                                    callback: function(value) {
                                        return value.toLocaleString();
                                    }
                                }
                            }
                        },
                        elements: {
                            point: {
                                radius: 4,
                                hoverRadius: 6
                            }
                        }
                    }
                });
            }

            // Refresh chart when Livewire updates
            document.addEventListener('livewire:update', function () {
                setTimeout(initChart, 100); // Small delay to ensure DOM is updated
            });
        </script>
    @endif
</div>
