<div>
    <div class="card border-0 shadow-sm h-100">
        <div class="card-header bg-transparent border-0 pb-0">
            <h6 class="mb-0 fw-bold">
                <i class="fas fa-chart-bar me-2 text-primary"></i>
                Garments Due to Ship
            </h6>
            <small class="text-muted">Monthly view - 3 years history</small>
        </div>
        <div class="card-body">
            @if($isLoading)
                <div class="d-flex justify-content-center align-items-center" style="height: 300px;">
                    <div class="text-center">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <p class="mt-2 text-muted">Loading chart data...</p>
                    </div>
                </div>
            @else
                <div class="position-relative" style="height: 300px;">
                    <canvas id="garmentsDueChart"></canvas>
                </div>
            @endif
        </div>
    </div>

    @if(!$isLoading)
        <script>
            document.addEventListener('livewire:load', function () {
                const ctx = document.getElementById('garmentsDueChart').getContext('2d');
                
                const chartData = @json($chartData);
                
                new Chart(ctx, {
                    type: 'line',
                    data: chartData,
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        interaction: {
                            intersect: false,
                            mode: 'index'
                        },
                        plugins: {
                            legend: {
                                position: 'top',
                                labels: {
                                    usePointStyle: true,
                                    padding: 20
                                }
                            },
                            tooltip: {
                                callbacks: {
                                    label: function(context) {
                                        return context.dataset.label + ': ' + context.parsed.y.toLocaleString() + ' garments';
                                    }
                                }
                            }
                        },
                        scales: {
                            x: {
                                display: true,
                                title: {
                                    display: true,
                                    text: 'Month'
                                },
                                grid: {
                                    display: false
                                }
                            },
                            y: {
                                display: true,
                                title: {
                                    display: true,
                                    text: 'Garments Due'
                                },
                                beginAtZero: true,
                                ticks: {
                                    callback: function(value) {
                                        return value.toLocaleString();
                                    }
                                }
                            }
                        },
                        elements: {
                            point: {
                                radius: 4,
                                hoverRadius: 6
                            }
                        }
                    }
                });
            });

            // Refresh chart when Livewire updates
            document.addEventListener('livewire:update', function () {
                if (document.getElementById('garmentsDueChart')) {
                    // Chart will be recreated on next render
                }
            });
        </script>
    @endif
</div>
