<div class="position-relative" x-data="{ open: false }" @click.away="open = false">
    <input 
        type="text" 
        wire:model.live.debounce.300ms="search"
        class="form-control ys-search w-100" 
        placeholder="Search for yarns..."
        @focus="open = true; $wire.showResults = true"
    >
    
    @if($showResults && count($results) > 0)
        <div class="position-absolute w-100 bg-white border rounded shadow-lg mt-2 p-3" style="z-index: 1000; max-height: 400px; overflow-y: auto;" x-show="open">
            <div class="mb-2">
                <small class="text-muted">{{ count($results) }} result{{ count($results) !== 1 ? 's' : '' }} found</small>
            </div>
            @foreach($results as $item)
                <a href="{{ route('product.show', $item->slug) }}" 
                   wire:click="selectResult"
                   class="d-flex align-items-center text-decoration-none text-dark p-2 rounded hover-bg-light mb-2">
                    @php
                        $itemImage = $item->primary_image;
                        if (!$itemImage && $item->colourways && $item->colourways->count() > 0) {
                            $colourwayWithImage = $item->colourways->firstWhere('image', '!=', null);
                            if ($colourwayWithImage) {
                                $itemImage = $colourwayWithImage->image;
                            }
                        }
                    @endphp
                    @if($itemImage)
                        <img src="{{ Storage::url($itemImage) }}" 
                             alt="{{ $item->name }}" 
                             class="rounded me-3"
                             style="width: 50px; height: 50px; object-fit: cover;">
                    @else
                        <div class="bg-secondary rounded me-3 d-flex align-items-center justify-content-center" 
                             style="width: 50px; height: 50px;">
                            <span class="text-white">No Image</span>
                        </div>
                    @endif
                    <div class="flex-grow-1">
                        <div class="fw-semibold">{{ $item->name }}</div>
                        <small class="text-muted">
                            {{ $item->season?->name }} | {{ $item->category?->name }}
                        </small>
                    </div>
                    <div class="text-end">
                        <span class="fw-bold" style="color: var(--ys-primary);">{{ $item->formatted_price }}</span>
                    </div>
                </a>
            @endforeach
            
            @if(strlen($search) > 0)
                <div class="border-top pt-2 mt-2">
                    <a href="{{ route('shop.search', ['q' => $search]) }}" 
                       class="btn btn-sm btn-ys-primary w-100"
                       wire:click="selectResult">
                        View all results for "{{ $search }}"
                    </a>
                </div>
            @endif
        </div>
    @endif
</div>

