<?php

namespace App\Contracts;

use App\Models\PlaybackEvent;
use App\Models\Track;
use App\Models\User;

interface PlaybackService
{
    /**
     * Log a playback event (play|complete).
     */
    public function log(string $event, User $user, Track $track, ?\DateTimeInterface $at = null): PlaybackEvent;

    /**
     * Aggregate counts for a track in a time window.
     * @return array<string,int> keyed by event
     */
    public function aggregatesForTrack(Track $track, ?\DateTimeInterface $from = null, ?\DateTimeInterface $to = null): array;

    /**
     * Aggregate counts for a user in a time window.
     * @return array<string,int> keyed by event
     */
    public function aggregatesForUser(User $user, ?\DateTimeInterface $from = null, ?\DateTimeInterface $to = null): array;
}


