<div>
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb ys-breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('shop.all') }}">Shop</a></li>
                <li class="breadcrumb-item active">{{ $category->name }}</li>
            </ol>
        </nav>
        
        <h1 class="fw-bold mb-2">{{ $category->name }}</h1>
        @if($category->description)
            <p class="text-muted">{{ $category->description }}</p>
        @endif
    </div>
</div>

<div class="container py-5">
    <div class="row mb-4">
        <div class="col-md-6">
            <select wire:model.live="selectedSeason" class="form-select">
                <option value="">All Seasons</option>
                @foreach($seasons as $season)
                    <option value="{{ $season->slug }}">{{ $season->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-6">
            <select wire:model.live="sortBy" class="form-select">
                <option value="latest">Latest</option>
                <option value="name">Name (A-Z)</option>
                <option value="price_asc">Price (Low to High)</option>
                <option value="price_desc">Price (High to Low)</option>
            </select>
        </div>
    </div>

    @if($products->count() > 0)
        <div class="product-grid mb-4">
            @foreach($products as $product)
                <div class="product-card" wire:key="product-{{ $product->id }}">
                    <a href="{{ route('product.show', $product->slug) }}" class="text-decoration-none">
                        @php
                            $productImage = $product->primary_image;
                            if (!$productImage && $product->colourways && $product->colourways->count() > 0) {
                                $colourwayWithImage = $product->colourways->firstWhere('image', '!=', null);
                                if ($colourwayWithImage) {
                                    $productImage = $colourwayWithImage->image;
                                }
                            }
                        @endphp
                        @if($productImage)
                            <img src="{{ Storage::url($productImage) }}" 
                                 alt="{{ $product->name }}"
                                 loading="lazy">
                        @else
                            <div class="placeholder-box" 
                                 style="height: 300px;">
                                <span>No Image</span>
                            </div>
                        @endif
                        
                        <div class="p-3">
                            @if($product->season)
                                <span class="badge badge-ys-primary small mb-2">{{ $product->season->name }}</span>
                            @endif
                            
                            <h5 class="fw-bold mb-2" style="color: var(--ys-text-primary);">
                                {{ $product->name }}
                            </h5>
                            
                            @if($product->short_description)
                                <p class="text-muted small mb-2">
                                    {{ Str::limit($product->short_description, 60) }}
                                </p>
                            @endif
                            
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-bold h5 mb-0" style="color: var(--ys-primary);">
                                    {{ $product->formatted_price }}
                                </span>
                                <span class="btn btn-sm btn-ys-primary">View Details</span>
                            </div>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>

        <div class="d-flex justify-content-center">
            {{ $products->links() }}
        </div>
    @else
        <div class="text-center py-5">
            <h4 class="fw-bold mb-2">No products found in this category</h4>
            <p class="text-muted mb-3">Check back soon for new arrivals</p>
            <a href="{{ route('shop.all') }}" class="btn btn-ys-primary">
                Browse All Products
            </a>
        </div>
    @endif
</div>
</div>

