<?php

/**
 * Script to fix boot() method compatibility issues in Laravel models
 * This script converts all public static function boot() to protected static function booted(): void
 */

$models = [
    'app/Models/Shipment.php',
    'app/Models/CustomerOrderLineQuantities.php',
    'app/Models/YarnColours.php',
    'app/Models/CustomerOrders.php',
    'app/Models/ShipmentLineSizes.php',
    'app/Models/YarnOrder.php',
    'app/Models/YarnOrderLine.php',
    'app/Models/CustomerOrderFiles.php',
    'app/Models/YarnOrderFiles.php',
    'app/Models/SampleTypes.php',
    'app/Models/ShipmentLine.php',
    'app/Models/Samples.php',
    'app/Models/CommodityCodes.php',
    'app/Models/CustomerAgents.php',
    'app/Models/ShipmentFiles.php',
];

foreach ($models as $model) {
    $filePath = $model;
    
    if (!file_exists($filePath)) {
        echo "File not found: $filePath\n";
        continue;
    }
    
    $content = file_get_contents($filePath);
    
    // Replace public static function boot() with protected static function booted(): void
    $content = preg_replace(
        '/public static function boot\(\)\s*\{/',
        'protected static function booted(): void' . "\n    {\n        parent::booted();",
        $content
    );
    
    // Remove any parent::boot() calls that are now redundant
    $content = preg_replace('/parent::boot\(\);\s*\n\s*/', '', $content);
    
    // Clean up any double parent::booted() calls
    $content = preg_replace('/parent::booted\(\);\s*parent::booted\(\);/', 'parent::booted();', $content);
    
    file_put_contents($filePath, $content);
    echo "Fixed: $filePath\n";
}

echo "All models have been updated!\n";
