<div>
<div class="py-5 text-center" style="background: linear-gradient(135deg, var(--ys-primary) 0%, var(--ys-primary-light) 100%); color: white;">
    <div class="container">
        <nav aria-label="breadcrumb" class="mb-4">
            <ol class="breadcrumb justify-content-center" style="--bs-breadcrumb-divider-color: rgba(255,255,255,0.5);">
                <li class="breadcrumb-item"><a href="{{ route('home') }}" class="text-white">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('shop.all') }}" class="text-white">Shop</a></li>
                <li class="breadcrumb-item active text-white">{{ $season->name }}</li>
            </ol>
        </nav>

        <h1 class="display-4 fw-bold mb-3">{{ $season->name }}</h1>
        @if($season->description)
            <p class="lead mb-0">{{ $season->description }}</p>
        @endif
    </div>
</div>

<div class="container py-5">
    <div class="row mb-4">
        <div class="col-md-6">
            <!-- Category Filter -->
            <select wire:model.live="selectedCategory" class="form-select">
                <option value="">All Categories</option>
                @foreach($categories as $category)
                    <option value="{{ $category->slug }}">{{ $category->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-6">
            <!-- Sort -->
            <select wire:model.live="sortBy" class="form-select">
                <option value="latest">Latest</option>
                <option value="name">Name (A-Z)</option>
                <option value="price_asc">Price (Low to High)</option>
                <option value="price_desc">Price (High to Low)</option>
            </select>
        </div>
    </div>

    @if($products->count() > 0)
        <div class="product-grid mb-4">
            @foreach($products as $product)
                <div class="product-card" wire:key="product-{{ $product->id }}">
                    <a href="{{ route('product.show', $product->slug) }}" class="text-decoration-none">
                        @if($product->primary_image)
                            <img src="{{ Storage::url($product->primary_image) }}" 
                                 alt="{{ $product->name }}"
                                 loading="lazy">
                        @else
                            <div class="placeholder-box" 
                                 style="height: 300px;">
                                <span>No Image</span>
                            </div>
                        @endif
                        
                        <div class="p-3">
                            @if($product->category)
                                <span class="badge badge-ys-accent small mb-2">{{ $product->category->name }}</span>
                            @endif
                            
                            <h5 class="fw-bold mb-2" style="color: var(--ys-text-primary);">
                                {{ $product->name }}
                            </h5>
                            
                            @if($product->short_description)
                                <p class="text-muted small mb-2">
                                    {{ Str::limit($product->short_description, 60) }}
                                </p>
                            @endif
                            
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-bold h5 mb-0" style="color: var(--ys-primary);">
                                    {{ $product->formatted_price }}
                                </span>
                                <span class="btn btn-sm btn-ys-primary">View Details</span>
                            </div>
                        </div>
                    </a>
                </div>
            @endforeach
        </div>

        <div class="d-flex justify-content-center">
            {{ $products->links() }}
        </div>
    @else
        <div class="text-center py-5">
            <h4 class="fw-bold mb-2">No products found in this collection</h4>
            <p class="text-muted mb-3">Check back soon for new arrivals</p>
            <a href="{{ route('shop.all') }}" class="btn btn-ys-primary">
                Browse All Products
            </a>
        </div>
    @endif
</div>
</div>

