# Stripe Quick Start Guide

## 🚀 Get Started in 5 Minutes

### 1. Get Your Keys
```bash
# You have your publishable key:
pk_test_51SQqD1FSPBHdTZaUQjQXLLiGS0HVDzNHMb4IV8ZqEeJ8vYZEaAqHzhLZp7PLPClfvl8vO4YyY0SowRJSR8cImhOJ00lPJyIDJR

# Get your secret key from:
https://dashboard.stripe.com/test/apikeys
```

### 2. Create Products
Go to https://dashboard.stripe.com/test/products and create:

| Product | Price | Description |
|---------|-------|-------------|
| Vybe Photo - Starter | £10/mo | 1,000 photos, 5GB storage |
| Vybe Photo - Professional | £25/mo | 10,000 photos, 50GB storage, custom domain |
| Vybe Photo - Business | £75/mo | 30,000 photos, 150GB storage, multiple domains |

Copy each **Price ID** (starts with `price_`)

### 3. Set Environment Variables
Create `.env` file:

```bash
# Stripe Keys
STRIPE_PUBLISHABLE_KEY=pk_test_51SQqD1FSPBHdTZaUQjQXLLiGS0HVDzNHMb4IV8ZqEeJ8vYZEaAqHzhLZp7PLPClfvl8vO4YyY0SowRJSR8cImhOJ00lPJyIDJR
STRIPE_SECRET_KEY=sk_test_YOUR_SECRET_KEY_HERE

# Price IDs (from Step 2)
STRIPE_PRICE_STARTER=price_XXXXXXXXXXXXXXXX
STRIPE_PRICE_PROFESSIONAL=price_YYYYYYYYYYYYYYYY
STRIPE_PRICE_BUSINESS=price_ZZZZZZZZZZZZZZZZ

# Webhook Secret (get from Step 4)
STRIPE_WEBHOOK_SECRET=whsec_YOUR_WEBHOOK_SECRET

# App Config
BASE_URL=http://localhost:3000
```

### 4. Set Up Webhooks (Local Development)
```bash
# Install Stripe CLI
brew install stripe/stripe-cli/stripe  # macOS
# or download from: https://stripe.com/docs/stripe-cli

# Listen for webhooks
stripe listen --forward-to localhost:3000/webhooks/stripe

# Copy the webhook signing secret to your .env file
```

### 5. Test It!
```bash
# Start your server
npm start

# Navigate to
http://localhost:3000/admin/subscription

# Test card number
4242 4242 4242 4242
```

---

## 📋 Checklist

Before going live:

- [ ] Created all 3 products in Stripe
- [ ] Set all environment variables
- [ ] Tested subscription upgrade
- [ ] Tested billing portal access
- [ ] Verified webhooks are working
- [ ] Tested subscription cancellation

---

## 🔥 Common Test Cards

| Card Number | Result |
|-------------|--------|
| 4242 4242 4242 4242 | Success |
| 4000 0000 0000 0002 | Card declined |
| 4000 0025 0000 3155 | Requires 3D Secure |

More: https://stripe.com/docs/testing

---

## 🎯 Key Endpoints

| Endpoint | Purpose |
|----------|---------|
| `/admin/subscription` | View and manage subscription |
| `/admin/subscription/change` | Upgrade/downgrade plan |
| `/admin/subscription/cancel` | Cancel subscription |
| `/admin/subscription/payment-portal` | Manage payment methods |
| `/webhooks/stripe` | Receive Stripe events |

---

## 📞 Need Help?

- **Full Guide**: See `STRIPE-SETUP-GUIDE.md`
- **Stripe Docs**: https://stripe.com/docs
- **Test Mode Dashboard**: https://dashboard.stripe.com/test

---

## 🎉 You're Ready!

Once you complete the checklist above, your Stripe integration is live and ready to accept payments!

