<div class="modal-body">
    <div class="ys-search-bar mx-auto">
        <input 
            type="text" 
            wire:model.live.debounce.300ms="query" 
            class="ys-search-input" 
            placeholder="Search for yarns, colors, patterns..."
            autofocus>
        <span class="ys-search-icon">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
            </svg>
        </span>
    </div>

    @if($showResults && $query)
        <div class="mt-4">
            @if($results->count() > 0)
                <div class="list-group">
                    @foreach($results as $result)
                        <a href="{{ route('product', $result->slug) }}" class="list-group-item list-group-item-action">
                            <div class="d-flex align-items-center gap-3">
                                @if($result->primary_image)
                                    <img src="{{ Storage::url($result->primary_image) }}" 
                                         alt="{{ $result->name }}" 
                                         style="width: 50px; height: 50px; object-fit: cover; border-radius: 8px;">
                                @else
                                    <div style="width: 50px; height: 50px; background-color: var(--ys-bg-tertiary); border-radius: 8px;"></div>
                                @endif
                                <div class="flex-grow-1">
                                    <h6 class="mb-1">{{ $result->name }}</h6>
                                    <small class="text-muted">{{ $result->season->name }} • {{ $result->category->name }}</small>
                                </div>
                                <span class="fw-bold" style="color: var(--ys-primary);">
                                    {{ $result->formatted_price }}
                                </span>
                            </div>
                        </a>
                    @endforeach
                </div>
                
                @if($results->count() >= 5)
                    <div class="text-center mt-3">
                        <a href="{{ route('search', ['q' => $query]) }}" class="btn btn-ys-primary">
                            View All Results
                        </a>
                    </div>
                @endif
            @else
                <div class="text-center text-muted py-4">
                    <p>No products found matching "{{ $query }}"</p>
                    <small>Try different keywords or browse our <a href="{{ route('collections') }}">collections</a></small>
                </div>
            @endif
        </div>
    @endif
</div>
