<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Consent extends Model
{
    protected $fillable = [
        'user_id',
        'type',
        'description',
        'granted',
        'granted_at',
        'revoked_at',
        'metadata',
    ];

    protected $casts = [
        'granted' => 'boolean',
        'granted_at' => 'datetime',
        'revoked_at' => 'datetime',
        'metadata' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function scopeGranted($query)
    {
        return $query->where('granted', true);
    }

    public function scopeByType($query, $type)
    {
        return $query->where('type', $type);
    }

    public function isGranted(): bool
    {
        return $this->granted === true;
    }

    public function isRevoked(): bool
    {
        return $this->revoked_at !== null;
    }

    public function grant(): void
    {
        $this->update([
            'granted' => true,
            'granted_at' => now(),
            'revoked_at' => null,
        ]);
    }

    public function revoke(): void
    {
        $this->update([
            'granted' => false,
            'revoked_at' => now(),
        ]);
    }
}
