<div id="page-content">
    <x-title-bar>
        <x-slot:title>
            Factory PO
        </x-slot:title>
        <x-slot:end>

        </x-slot:end>
        <x-slot:sub>
            <div class="row mt-2 d-xl-none">
                <div class="col text-end">
                    <button class="btn btn-primary" wire:click="$toggle('hideFilters')">{{$hideFilters ? 'Show' :'Hide'}}</button>
                </div>
            </div>
            @if(!$hideFilters)
                <div class="row mt-2 mx-1">
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" wire:model.live="filter.season">
                                @foreach($this->seasons as $season)
                                    <option value="{{ $season->id }}">{{ $season->description }}</option>
                                @endforeach
                            </select>
                            <label class="form-label">Season:</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" wire:model.live="filter.factory">
                                <option value="">All</option>
                                @foreach($this->factories as $factory)
                                    <option value="{{ $factory->id }}">{{ $factory->name }}</option>
                                @endforeach
                            </select>
                            <label class="form-label">Factory:</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" wire:model.live="filter.customer">
                                @foreach($this->customers as $customer)
                                    <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                @endforeach
                            </select>
                            <label class="form-label">Customer:</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <select class="form-select" wire:model.live="filter.address">
                                <option value="">All</option>
                                @foreach($this->customers->find($filter['customer'])->customer_addresses as $address)
                                    <option value="{{ $address->id }}">{{ $address->name }}</option>
                                @endforeach
                            </select>
                            <label class="form-label">Address:</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div x-data="{ open: $wire.entangle('showPODropdown') }">
                            <button class="btn w-100  border border-primary bg-white" style="height: calc(3.5rem + 2px);" x-on:click="open = true">POs @if(empty($po)) (All) @else() ({{count($po)}} Selected) @endif</button>

                            <ul class="dropdown-menu show mt-2" style="max-height: 50vh; overflow-y: auto; scrollbar-width: thin;" x-show="open" x-on:click.outside="open = false">
                                <li class="px-3 py-1">
                                    <button class="btn btn-primary w-100" wire:click="select('po')">All</button>
                                </li>
                                @foreach($this->getPOs() as $i=>$cust_po)
                                    <li class="px-3 py-1 @if($po[$cust_po->id] ?? 0) bg-good @endif">
                                        <span style="cursor: pointer;" wire:click="select('po', {{$cust_po->id}})">{{ $cust_po->customer_po }}</span><br>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <div class="form-floating form-outline">
                            <input type="date" class="form-control" wire:model.live="filter.created_since">
                            <label class="form-label">Created Since:</label>
                        </div>
                    </div>
                    <div class="col-xl col-6 mb-2 px-1">
                        <button class="btn w-100 bg-white btn-outline border-primary" style="height: calc(3.5rem + 2px);" type="button" wire:click="clearFilters">
                            Clear
                        </button>
                    </div>
                </div>
            @endif
        </x-slot:sub>
    </x-title-bar>

    <div id="page-content-container" class="container-fluid">
        <div class="row">
            <div class="col">
                @if (Session::get('message'))
                    <div class="alert {{ Session::get('alert-class') }}" role="alert">
                        {{ Session::get('message') }}
                    </div>
                @endif
                @if($errors->all())
                    <div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }}" role="alert">
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
        <div class="row mt-3">
            <div class="col d-flex align-items-stretch">
                <div class="card mb-3 w-100">
                    <div class="card-header">PO Details</div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                @if(!empty($filter['factory']))
                                    <div class="row align-items-center">
                                        <div class="col-sm-5">
                                            <h6 class="mb-0 fw-bold">PO Date</h6>
                                        </div>
                                        <div class="col-sm-7 text-secondary">{{ Carbon\Carbon::now()->format('Y-m-d (D)') }}</div>
                                    </div>
                                    <hr>
                                    <div class="row align-items-center">
                                        <div class="col-sm-5">
                                            <h6 class="mb-0 fw-bold">Factory</h6>
                                        </div>
                                        <div class="col-sm-7 text-secondary">
                                            <b>{{ $this->factories->find($filter['factory'])->name }}</b><br>
                                            {{ $this->factories->find($filter['factory'])->supplier_addresses->first()?->line1 }}@if($this->factories->find($filter['factory'])->supplier_addresses->first()?->line1 != NULL)<br>@endif
                                            {{ $this->factories->find($filter['factory'])->supplier_addresses->first()?->line2 }}@if($this->factories->find($filter['factory'])->supplier_addresses->first()?->line2 != NULL)<br>@endif
                                            {{ $this->factories->find($filter['factory'])->supplier_addresses->first()?->line3 }}@if($this->factories->find($filter['factory'])->supplier_addresses->first()?->line3 != NULL)<br>@endif
                                            {{ $this->factories->find($filter['factory'])->supplier_addresses->first()?->city }}@if($this->factories->find($filter['factory'])->supplier_addresses->first()?->city != NULL)<br>@endif
                                            {{ $this->factories->find($filter['factory'])->supplier_addresses->first()?->region }}@if($this->factories->find($filter['factory'])->supplier_addresses->first()?->region != NULL)<br>@endif
                                            {{ $this->factories->find($filter['factory'])->supplier_addresses->first()?->postcode }}@if($this->factories->find($filter['factory'])->supplier_addresses->first()?->postcode != NULL)<br>@endif
                                            {{ $this->factories->find($filter['factory'])->supplier_addresses->first()?->countries->country }}
                                        </div>
                                    </div>
                                    <hr>
                                    <div class="row align-items-center">
                                        <div class="col-sm-5">
                                            <h6 class="mb-0 fw-bold">Season</h6>
                                        </div>
                                        <div class="col-sm-7 text-secondary">{{ $this->seasons->find($filter['season'])->description }}</div>
                                    </div>
                                    <hr>
                                    <div class="row align-items-center">
                                        <div class="col-sm-5">
                                            <h6 class="mb-0 fw-bold">Currency</h6>
                                        </div>
                                        <div class="col-sm-7 text-secondary">{{ $this->factories->find($filter['factory'])->currency }}</div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col d-flex align-items-stretch">
                <div class="card mb-3 w-100">
                    <div class="card-header">Delivery Details</div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <div class="row align-items-center">
                                    <div class="col-sm-5">
                                        <h6 class="fw-bold">Customer</h6>
                                    </div>
                                    <div class="col-sm-7 text-secondary">{{ $this->customers->find($filter['customer'])->name }}</div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-sm-5">
                                        <h6 class="mb-0 fw-bold">Delivery Address</h6>
                                    </div>
                                    <div class="col-sm-7 text-secondary">
                                        {{ $this->customers->find($filter['customer'])->customer_addresses->find($filter['address'])?->line1 }}<br>
                                        {{ $this->customers->find($filter['customer'])->customer_addresses->find($filter['address'])?->line2 }}<br>
                                        {{ $this->customers->find($filter['customer'])->customer_addresses->find($filter['address'])?->line3 }}<br>
                                        {{ $this->customers->find($filter['customer'])->customer_addresses->find($filter['address'])?->city }}<br>
                                        {{ $this->customers->find($filter['customer'])->customer_addresses->find($filter['address'])?->region }}<br>
                                        {{ $this->customers->find($filter['customer'])->customer_addresses->find($filter['address'])?->postcode }}<br>
                                        {{ $this->customers->find($filter['customer'])->customer_addresses->find($filter['address'])?->countries->country }}<br>
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-sm-5">
                                        <h6 class="fw-bold">Comments<br><span class="dont-print fw-normal">(not saved)</span></h6>
                                    </div>
                                    <div class="col-sm-7 text-secondary"><textarea class="form-control" rows="5"></textarea></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col d-flex align-items-stretch">
                <div class="card mb-3 w-100">
                    <div class="card-header">Agent Details</div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <div class="row align-items-center">
                                    <div class="col-sm-5">
                                        <h6 class="mb-0 fw-bold">Agent</h6>
                                    </div>
                                    <div class="col-sm-7 text-secondary">Robert Todd & Son Ltd</div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-sm-5">
                                        <h6 class="mb-0 fw-bold">Operations Contact</h6>
                                    </div>
                                    <div class="print col-sm-7 text-secondary">
                                        {{ $contact['name'] }}<br>
                                        {{ $contact['phone'] }}<br>
                                        {{ $contact['email'] }}
                                    </div>
                                    <div class="dont-print col-sm-7 text-secondary">
                                        <input type="text" class="form-control mb-1" value="{{$contact['name']}}">
                                        <input type="text" class="form-control mb-1" value="{{$contact['phone']}}">
                                        <input type="text" class="form-control mb-1" value="{{$contact['email']}}">
                                    </div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col-sm-5">
                                        <h6 class="mb-0 fw-bold">Finance Contact</h6>
                                    </div>
                                    <div class="col-sm-7 text-secondary">
                                        Finance<br>
                                        15 Etterby Scaur<br>
                                        Carlisle<br>
                                        Cumbria<br>
                                        CA3 1PA<br>
                                        01509 788979<br>
                                        finance@roberttodds.com
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
    <div class="row">
        <div class="col-12">
            @if (Session::get('message'))
                <div class="alert {{ Session::get('alert-class') }}" role="alert">
                    {{ Session::get('message') }}
                </div>
            @endif
        </div>
    </div>

    <div class="row p-3">
        <div class="col">
            <table class="table text-center align-middle">
                <thead>
                    <tr>
                        <td>Factory</td>
                        <td>Image</td>
                        <td>Issue Date</td>
                        <td>RT No.</td>
                        <td>PO No.</td>
                        <td>Shipment Mode</td>
                        <td>Customer Ref</td>
                        <td>Description</td>
                        <td>Colour Name</td>
                        <td>Yarn Quality/Colour</td>
                        {{-- <td>Yarn Colour Code</td> --}}
                        <td>Sizes</td>
                        <td>Total</td>
                        {{-- <td>Price</td> --}}
                        <td>Value</td>
                        <td>Yarn Order Ref</td>
                        <td>Ex Fty</td>
                    </tr>
                </thead>
                <tbody>
                    @foreach($shipments->sortBy(['exfty', 'customer_order_lines.customer_orders.customer_po', 'customer_order_lines.colourways.style_versions.styles_id']) as $shipment)
                        <tr style="page-break-inside: avoid;page-break-before:auto">
                            <td>{{$shipment->customer_order_lines->colourways->style_versions->factories->name}}</td>
                            <td>
                                @if($shipment->customer_order_lines->colourways->image != NULL)
                                    <img style="max-width: 150px; max-height: 150px;" class="img-fluid pb-3 rounded" src="{{$shipment->customer_order_lines->colourways->imageURL}}">
                                @endif
                            </td>
                            <td>{{ $shipment->customer_order_lines->customer_orders->order_date?->format('d-M') }}</td>
                            <td>{{ $shipment->customer_order_lines->colourways->style_versions->styles->designs->id }}</td>
                            <td role="button" style x-data x-on:click="$dispatch('open-modal', {name:'edit-order'})" wire:click="$dispatch('edit-order', {order: {{$shipment->customer_order_lines->customer_orders->id}}})" >{{ $shipment->customer_order_lines->customer_orders->customer_po }}</td>
                            <td>{{$shipment->customer_order_lines->customer_orders->shipment_mode}}</td>
                            <td role="button" style x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$shipment->customer_order_lines->colourways->style_versions->styles->id}}})" >{{ $shipment->customer_order_lines->colourways->style_versions->styles->customer_ref }}</td>
                            <td>{{ $shipment->customer_order_lines->colourways->style_versions->styles->designs->description }}</td>
                            <td>{{ $shipment->customer_order_lines->colourways->name }}</td>
                            <td>
                                @foreach($shipment->customer_order_lines->colourways->getYarns() as $yarn)
                                {{ $yarn['description'] }} {{ $yarn['count'] }} - {{ $yarn['colour'] }}<br>
                                @endforeach
                            </td>
                            <td style="min-width: 100px">
                                <table class="table">
                                    <tr>
                                        @foreach($shipment->shipment_line_sizes->sortBy('sizes.order') as $qty)
                                            <th>{{ $qty->sizes->name }}</th>
                                        @endforeach
                                    </tr>
                                    <tr>
                                        @foreach($shipment->shipment_line_sizes->sortBy('sizes.order') as $qty)
                                            <td>{{ $qty->qty }}</td>
                                        @endforeach
                                    </tr>
                                    <tr>
                                        @foreach($shipment->customer_order_lines->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                            @if($qty->SKU != NULL)
                                                <td>{{ $qty->SKU }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    <tr>
                                        @foreach($shipment->customer_order_lines->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                            @if($qty->barcode != NULL)
                                                <td>{{ $qty->barcode }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    <tr>
                                        @foreach($shipment->customer_order_lines->customer_order_line_quantities->sortBy('sizes.order') as $qty)
                                            <td>{{ $shipment->customer_order_lines->colourways->style_versions->factories->currency }}{{ $qty->price_model['cmt'] ?? 0 }}</td>
                                        @endforeach
                                    </tr>
                                </table>
                            </td>
                            <td class="fw-bold">{{ $shipment->shipment_line_sizes->sum('qty') }}</td>
                            {{-- <td>
                                @if(is_numeric($shipment->customer_order_lines->colourways->style_versions->cmt_if_confirmed())){{ $shipment->customer_order_lines->colourways->style_versions->factories->currency }}@endif{{ $shipment->customer_order_lines->colourways->style_versions->cmt_if_confirmed() }}
                            </td> --}}
                            <td>
                                {{ $shipment->customer_order_lines->colourways->style_versions->factories->currency }}{{ number_format($shipment->total_prices['cmt'] ?? 0, 2) }}
                            </td>
                            <td>
                                @foreach($shipment->customer_order_lines->yarn_order_line_styles->unique('yarn_order_lines->yarn_order_id') as $prod)
                                    PROD{{$prod->yarn_order_lines->yarn_order_id}}<br>
                                @endforeach
                            </td>
                            <td>
                                    {{ $shipment->exfty?->format('d-M-Y') }}
                            </td>
                        </tr>
                    @endforeach
                        <tr class="fw-bold bg-primary text-white">
                            <td class="text-white">Grand Total</td>
                            <td class="text-white" colspan="9"></td>
                            <td class="text-white">{{$this->grandTotalQty()}}</td>
                            <td class="text-white"></td>
                            <td class="text-white">
                                {{ $shipments->first()?->customer_order_lines->colourways->style_versions->factories->currency }}{{ number_format($this->totalValue(), 2) }}
                            </td>
                            <td class="text-white" colspan="3"></td>
                        </tr>
                    </tbody>
                </table>
                <div class="row">
                    <div class="col">
                        <table class="table text-center">
                            <thead>
                                @foreach($this->sizeTotals() as $s=>$size)
                                    <th>{{$s}}</th>
                                @endforeach
                            </thead>
                            <tbody>
                                @foreach($this->sizeTotals() as $s=>$size)
                                    <td>{{$size['qty']}}</td>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    <x-modal name="edit-style" title="Edit Style">
        <x-slot:body>
                <livewire:development.styles.style-edit wire:key='editStyle'>
        </x-slot:body>
    </x-modal>
    <x-modal name="edit-order" title="Edit Order" size="modal-fullscreen">
        <x-slot:body>
                <livewire:sales.orders.orders-edit wire:key='editOrder'>
        </x-slot:body>
    </x-modal>



</div>
