<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('order_lines', function (Blueprint $table) {
            $table->integer('sort_order')->default(0)->after('attributes');
            $table->index(['order_id', 'sort_order']);
        });
    }

    public function down(): void
    {
        Schema::table('order_lines', function (Blueprint $table) {
            $table->dropIndex(['order_id', 'sort_order']);
            $table->dropColumn('sort_order');
        });
    }
};


