<div class="space-y-4">
    <h3 class="text-lg font-semibold">Statement #{{ $statement->id }} ({{ $statement->cardholder_name }})</h3>
    <p class="text-sm">{{ $statement->period_start->format('Y-m-d') }} to {{ $statement->period_end->format('Y-m-d') }}</p>

    <div class="overflow-x-auto">
        <table class="min-w-full text-sm">
            <thead>
                <tr class="text-left">
                    <th class="px-3 py-2">Date</th>
                    <th class="px-3 py-2">Merchant</th>
                    <th class="px-3 py-2">Amount</th>
                    <th class="px-3 py-2">Matches</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($statement->transactions as $txn)
                    <tr class="border-t">
                        <td class="px-3 py-2">{{ $txn->transaction_date?->format('Y-m-d') }}</td>
                        <td class="px-3 py-2">{{ $txn->merchant_name }}</td>
                        <td class="px-3 py-2">{{ number_format($txn->amount, 2) }} {{ $txn->currency }}</td>
                        <td class="px-3 py-2">
                            @forelse ($txn->matches as $match)
                                <div class="mb-1">
                                    Receipt #{{ $match->receipt_id }} — £{{ number_format($match->matched_amount, 2) }}
                                    <span class="text-xs text-gray-500">({{ $match->match_method }})</span>
                                </div>
                            @empty
                                <span class="text-xs text-gray-500">No matches</span>
                            @endforelse
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>


