<div class="space-y-6">
    @if (session('status'))
        <div class="mb-4 p-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-700 rounded-xl">
            <div class="flex items-center gap-2">
                <svg class="w-5 h-5 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <span class="text-green-800 dark:text-green-200">{{ session('status') }}</span>
            </div>
        </div>
    @endif

    @if (session('error'))
        <div class="mb-4 p-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-700 rounded-xl">
            <div class="flex items-center gap-2">
                <svg class="w-5 h-5 text-red-600 dark:text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <span class="text-red-800 dark:text-red-200">{{ session('error') }}</span>
            </div>
        </div>
    @endif

    <!-- Header -->
    <div class="mb-6 p-6 bg-gradient-to-br from-indigo-50 to-indigo-100/50 dark:from-indigo-900/20 dark:to-indigo-800/20 rounded-2xl border border-indigo-200/50 dark:border-indigo-700/50" wire:poll.5s>
        <div class="flex items-center justify-between gap-3">
            <div class="flex items-center gap-3">
                <div class="p-3 bg-indigo-500/20 rounded-xl">
                    <svg class="w-6 h-6 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                </div>
                <div class="flex-1">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        Statement Review
                    </h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400">
                        Manage receipt matching and review statement transactions
                    </p>
                </div>
            </div>
            <div class="flex items-center gap-3">
                <div class="text-xs text-gray-700 dark:text-gray-300">
                    Unmatched receipts: <span class="font-semibold">{{ $unmatchedReceiptsCount ?? 0 }}</span>
                    · Unmatched lines: <span class="font-semibold">{{ $unmatchedTransactionsCount ?? 0 }}</span>
                </div>
                <button wire:click="runMatching" wire:loading.attr="disabled" class="inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-gradient-to-r from-indigo-600 to-indigo-700 text-white text-sm font-medium hover:from-indigo-700 hover:to-indigo-800 focus:outline-none focus:ring-2 focus:ring-indigo-500 transition-all">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V5a2 2 0 00-2-2H5zm10 0h4a2 2 0 012 2v4a2 2 0 01-2 2h-4a2 2 0 01-2-2V5a2 2 0 012-2zm-10 10h4a2 2 0 012 2v4a2 2 0 01-2 2H5a2 2 0 01-2-2v-4a2 2 0 012-2zm10 0h4a2 2 0 012 2v4a2 2 0 01-2 2h-4a2 2 0 01-2-2v-4a2 2 0 012-2z"/></svg>
                    <span wire:loading.remove wire:target="runMatching">Run Matching</span>
                    <span wire:loading wire:target="runMatching" class="inline-flex items-center gap-1">
                        <svg class="animate-spin h-4 w-4" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                        Processing...
                    </span>
                </button>
            </div>
        </div>
    </div>

    <!-- Receipts Section -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
        <!-- Unmatched Receipts -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 overflow-hidden">
            <div class="px-5 py-4 bg-gradient-to-br from-amber-50 to-amber-100/30 dark:from-amber-900/20 dark:to-amber-800/10 border-b border-amber-200/50 dark:border-amber-700/50">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-2">
                        <div class="p-2 bg-amber-500/20 rounded-lg">
                            <svg class="w-4 h-4 text-amber-600 dark:text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div>
                            <div class="text-xs font-semibold uppercase tracking-wide text-amber-900 dark:text-amber-300">Unmatched Receipts</div>
                            <div class="text-xs text-amber-700 dark:text-amber-400">{{ $unmatchedReceiptsCount ?? $unmatchedReceipts->count() }} items</div>
                        </div>
                    </div>
                    
                    @if($showMatchButton)
                    <div class="flex items-center gap-2">
                        <span class="text-xs text-amber-700 dark:text-amber-400">
                            {{ count($selectedReceipts) }} selected
                        </span>
                        <button type="button" wire:click="matchSelectedReceipts" 
                                wire:loading.attr="disabled"
                                class="px-3 py-1.5 text-xs font-medium rounded-lg bg-green-600 text-white hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2 transition-colors disabled:opacity-50 disabled:cursor-not-allowed">
                            <span class="flex items-center gap-1" wire:loading.remove wire:target="matchSelectedReceipts">
                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                Match Selected
                            </span>
                            <span class="flex items-center gap-1" wire:loading wire:target="matchSelectedReceipts">
                                <svg class="w-3 h-3 animate-spin" fill="none" viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                </svg>
                                Matching...
                            </span>
                        </button>
                        <button type="button" wire:click="clearSelection" 
                                class="px-2 py-1.5 text-xs rounded border border-gray-300 text-gray-700 hover:bg-gray-50 dark:border-gray-600 dark:text-gray-300 dark:hover:bg-gray-700">
                            Clear
                        </button>
                    </div>
                    @endif
                </div>
            </div>
            <div class="max-h-[500px] overflow-y-auto">
                @forelse ($unmatchedReceipts as $r)
                <div class="px-5 py-4 border-b border-gray-100 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors {{ $this->isReceiptSelected($r->id) ? 'bg-indigo-50 dark:bg-indigo-900/20' : '' }}">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-3">
                            <input type="checkbox" 
                                   wire:click="toggleReceiptSelection({{ $r->id }})"
                                   {{ $this->isReceiptSelected($r->id) ? 'checked' : '' }}
                                   class="w-4 h-4 text-indigo-600 bg-gray-100 border-gray-300 rounded focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                            <div class="flex-1">
                                <div class="font-medium text-gray-900 dark:text-white mb-1">{{ $r->merchant_name ?? 'Unknown Merchant' }}</div>
                                <div class="flex items-center gap-3 text-xs text-gray-600 dark:text-gray-400">
                                    <span class="flex items-center gap-1">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                                        {{ $r->receipt_date?->format('d M Y') }}
                                    </span>
                                    <span class="flex items-center gap-1 font-semibold text-amber-700 dark:text-amber-400">
                                        £{{ number_format($r->total_amount,2) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="flex items-center gap-2 ml-3">
                            <button type="button" wire:click.stop="selectReceipt({{ $r->id }})" x-on:click.stop class="p-2 text-gray-400 hover:text-blue-600 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded-lg transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                </svg>
                            </button>
                            <button type="button" wire:click.stop="reprocessReceipt({{ $r->id }})" class="px-2 py-1 text-xs rounded border border-indigo-300 text-indigo-700 hover:bg-indigo-50 dark:border-indigo-600 dark:text-indigo-300 dark:hover:bg-indigo-900/20">
                                Re‑OCR
                            </button>
                            <button type="button" wire:click.stop="matchReceipt({{ $r->id }})" wire:loading.attr="disabled" class="px-2 py-1 text-xs rounded border border-green-300 text-green-700 hover:bg-green-50 dark:border-green-600 dark:text-green-300 dark:hover:bg-green-900/20">
                                <span wire:loading.remove wire:target="matchReceipt">AI Match</span>
                                <span wire:loading wire:target="matchReceipt">Matching...</span>
                            </button>
                            <button type="button" wire:click.stop="openManualMatchModal({{ $r->id }})" class="px-2 py-1 text-xs rounded border border-purple-300 text-purple-700 hover:bg-purple-50 dark:border-purple-600 dark:text-purple-300 dark:hover:bg-purple-900/20">
                                Match
                            </button>
                            <button type="button" onclick="document.getElementById('testModal').classList.remove('hidden')" class="px-2 py-1 text-xs rounded border border-orange-300 text-orange-700 hover:bg-orange-50 dark:border-orange-600 dark:text-orange-300 dark:hover:bg-orange-900/20">
                                JS Test
                            </button>
                        </div>
                    </div>
                </div>
                @empty
                <div class="px-5 py-12 text-center">
                    <div class="w-12 h-12 mx-auto mb-3 p-3 bg-gray-100 dark:bg-gray-700 rounded-full">
                        <svg class="w-full h-full text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                    </div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">All receipts matched</p>
                </div>
                @endforelse
            </div>
        </div>

        <!-- Matched Receipts -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 overflow-hidden">
            <div class="px-5 py-4 bg-gradient-to-br from-green-50 to-green-100/30 dark:from-green-900/20 dark:to-green-800/10 border-b border-green-200/50 dark:border-green-700/50">
                <div class="flex items-center gap-2">
                    <div class="p-2 bg-green-500/20 rounded-lg">
                        <svg class="w-4 h-4 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div>
                        <div class="text-xs font-semibold uppercase tracking-wide text-green-900 dark:text-green-300">Matched Receipts</div>
                        <div class="text-xs text-green-700 dark:text-green-400">{{ $matchedReceipts->count() }} items</div>
                    </div>
                </div>
            </div>
            <div class="max-h-[500px] overflow-y-auto">
                @forelse ($matchedReceipts as $r)
                <div class="px-5 py-4 border-b border-gray-100 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <div class="flex items-center gap-2 mb-1">
                                <div class="font-medium text-gray-900 dark:text-white">{{ $r->merchant_name ?? 'Unknown Merchant' }}</div>
                                @if($r->matches->count() > 0)
                                    @php
                                        $match = $r->matches->first();
                                        $transaction = $match->statementTransaction;
                                        $totalReceiptsForTransaction = $transaction->matches->count();
                                    @endphp
                                    @if($totalReceiptsForTransaction > 1)
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900/30 dark:text-blue-300">
                                            <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/>
                                            </svg>
                                            Grouped ({{ $totalReceiptsForTransaction }})
                                        </span>
                                    @endif
                                @endif
                            </div>
                            <div class="flex items-center gap-3 text-xs text-gray-600 dark:text-gray-400">
                                <span class="flex items-center gap-1">
                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                                    {{ $r->receipt_date?->format('d M Y') }}
                                </span>
                                <span class="flex items-center gap-1 font-semibold text-green-700 dark:text-green-400">
                                    £{{ number_format($r->total_amount,2) }}
                                </span>
                                @if($r->matches->count() > 0)
                                    @php
                                        $match = $r->matches->first();
                                        $transaction = $match->statementTransaction;
                                    @endphp
                                    <span class="text-xs text-gray-500 dark:text-gray-400">
                                        → {{ $transaction->merchant_name }} (£{{ number_format($transaction->amount, 2) }})
                                    </span>
                                @endif
                            </div>
                        </div>
                        <button type="button" wire:click.stop="selectReceipt({{ $r->id }})" x-on:click.stop class="ml-3 p-2 text-gray-400 hover:text-blue-600 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded-lg transition-colors">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                            </svg>
                        </button>
                    </div>
                                </div>
                            @empty
                <div class="px-5 py-12 text-center">
                    <div class="w-12 h-12 mx-auto mb-3 p-3 bg-gray-100 dark:bg-gray-700 rounded-full">
                        <svg class="w-full h-full text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"/></svg>
                    </div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">No matches yet</p>
                </div>
                            @endforelse
            </div>
        </div>
    </div>

    <!-- Receipt Edit Modal -->
    @if($selectedReceiptId)
        @php
            $receipt = \App\Models\Receipt::find($selectedReceiptId);
        @endphp
        @if($receipt)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeModal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-2/3 lg:w-1/2 shadow-lg rounded-md bg-white dark:bg-gray-800" wire:click.stop>
                <div class="mt-3">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white">Edit Receipt</h3>
                        <button wire:click="closeModal" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </button>
                    </div>
                    
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Merchant Name</label>
                            <input type="text" wire:model="editReceipt.merchant_name" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 dark:bg-gray-700 dark:text-white">
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Total Amount</label>
                            <input type="number" step="0.01" wire:model="editReceipt.total_amount" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 dark:bg-gray-700 dark:text-white">
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Receipt Date</label>
                            <input type="date" wire:model="editReceipt.receipt_date" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 dark:bg-gray-700 dark:text-white">
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Currency</label>
                            <select wire:model="editReceipt.currency" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 dark:bg-gray-700 dark:text-white">
                                <option value="GBP">GBP</option>
                                <option value="USD">USD</option>
                                <option value="EUR">EUR</option>
                            </select>
    </div>
</div>

                    <div class="mt-4 flex justify-end gap-2">
                        <button type="button" class="px-3 py-2 text-sm rounded border border-gray-300 hover:bg-gray-50" @click="openReceiptId = null; $wire.closeModal()">Cancel</button>
                        <button type="button" class="px-3 py-2 text-sm rounded bg-indigo-600 text-white hover:bg-indigo-700" wire:click="saveReceiptEdits">Save</button>
                    </div>
                @endif
        @else
        <div class="px-5 py-12 text-center">
            <div class="w-12 h-12 mx-auto mb-3 p-3 bg-gray-100 dark:bg-gray-700 rounded-full">
                <svg class="w-full h-full text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>       
                </svg>
            </div>
            <p class="text-gray-500 dark:text-gray-400">Receipt not found</p>                                                                           
        </div>
        @endif
    </div>

    <!-- Debug Info -->
    <div class="fixed top-4 right-4 bg-red-500 text-white p-2 rounded text-xs z-50">
        Modal State: {{ $showManualMatchModal ? 'TRUE' : 'FALSE' }}
        @if($manualMatchReceiptId)
            | Receipt: {{ $manualMatchReceiptId }}
        @endif
    </div>

    <!-- Simple Test Modal -->
    <div id="testModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
        <div class="fixed inset-0 flex items-center justify-center p-4">
            <div class="bg-white rounded-lg shadow-xl max-w-md w-full p-6">
                <h3 class="text-lg font-bold text-green-600 mb-4">Test Modal Works!</h3>
                <p class="text-gray-600 mb-4">This is a simple JavaScript modal.</p>
                <button onclick="document.getElementById('testModal').classList.add('hidden')" class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                    Close
                </button>
            </div>
        </div>
    </div>

    <!-- Manual Match Modal -->
    @if($showManualMatchModal)
    <div class="fixed inset-0 bg-black bg-opacity-50 z-50" style="z-index: 9999 !important;">
        <div class="fixed inset-0 flex items-center justify-center p-4">
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-xl max-w-2xl w-full max-h-[90vh] overflow-y-auto">
                <div class="p-6">
                    <!-- Header -->
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white">Manual Receipt Match</h3>
                        <button wire:click="closeManualMatchModal" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </button>
                    </div>
                    
                    <div class="text-center py-8">
                        <h4 class="text-xl font-bold text-green-600">Modal is working!</h4>
                        <p class="text-gray-600">Receipt ID: {{ $manualMatchReceiptId }}</p>
                        <button wire:click="closeManualMatchModal" class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                            Close Modal
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>