<?php

namespace App\Http\Controllers;

use App\Models\Favorite;
use App\Models\Track;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class FavoritesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function toggle(Request $request, Track $track): RedirectResponse
    {
        $user = $request->user();
        $exists = Favorite::query()->where('user_id', $user->id)->where('track_id', $track->id)->exists();

        if ($exists) {
            Favorite::query()->where('user_id', $user->id)->where('track_id', $track->id)->delete();
        } else {
            Favorite::create([
                'user_id' => $user->id,
                'track_id' => $track->id,
                'created_at' => now(),
            ]);
        }

        return back();
    }
}


