import './bootstrap';
import 'bootstrap/dist/js/bootstrap.bundle.min.js';

// Import Livewire
import { Livewire, Alpine } from '../../vendor/livewire/livewire/dist/livewire.esm';

// Import Alpine.js
import Alpine from 'alpinejs';

// Make Alpine available globally
window.Alpine = Alpine;

// Start Alpine
Alpine.start();

// Start Livewire
Livewire.start();

// Custom JavaScript for VybeHypnosis
document.addEventListener('DOMContentLoaded', function() {
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });

    // Initialize popovers
    var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));
    var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
        return new bootstrap.Popover(popoverTriggerEl);
    });

    // Custom functions for hypnotherapy app
    window.VybeHypnosis = {
        // Show loading spinner
        showLoading: function(element) {
            if (element) {
                element.innerHTML = '<div class="loading-spinner mx-auto"></div>';
            }
        },

        // Hide loading spinner
        hideLoading: function(element, content) {
            if (element && content) {
                element.innerHTML = content;
            }
        },

        // Smooth scroll to element
        scrollToElement: function(elementId) {
            const element = document.getElementById(elementId);
            if (element) {
                element.scrollIntoView({ behavior: 'smooth' });
            }
        },

        // Show notification
        showNotification: function(message, type = 'info') {
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert alert-${type} alert-dismissible fade show`;
            alertDiv.innerHTML = `
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            
            const container = document.querySelector('.container') || document.body;
            container.insertBefore(alertDiv, container.firstChild);
            
            // Auto remove after 5 seconds
            setTimeout(() => {
                if (alertDiv.parentNode) {
                    alertDiv.remove();
                }
            }, 5000);
        },

        // Format API response
        formatApiResponse: function(response) {
            return JSON.stringify(response, null, 2);
        }
    };
});
