<?php
// Minimal contact handler with PHPMailer and spam protection
// Google Workspace SMTP configuration
const SMTP_HOST = 'smtp.gmail.com';
const SMTP_USER = 'neil@neilwiddowson.co.uk';
const SMTP_PASS = ''; // Set your Google App Password here
const SMTP_PORT = 587;
const TO_EMAIL  = 'neil@neilwiddowson.co.uk';
const TO_NAME   = 'Neil Widdowson';

// Basic config
header('Content-Type: text/html; charset=utf-8');
function h($v) { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

// Validate request method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo '<p>Method not allowed.</p>';
  exit;
}

// Simple spam checks
$honeypot = $_POST['website'] ?? '';
if (!empty($honeypot)) {
  http_response_code(400);
  echo '<p>Thanks! Your message has been received.</p>'; // silent fail for bots
  exit;
}

// Required fields
$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$company = trim($_POST['company'] ?? '');
$message = trim($_POST['message'] ?? '');

if (!$name || !$email || !$company || !$message) {
  http_response_code(400);
  echo '<p>Please complete all required fields.</p>';
  exit;
}

// Compose email body
$body = "New enquiry from website:\n\n" .
        "Name: " . h($name) . "\n" .
        "Email: " . h($email) . "\n" .
        "Company: " . h($company) . "\n\n" .
        "Message:\n" . h($message) . "\n";

// Try to send mail; if PHPMailer not present, fallback to mail()
$useMailer = class_exists('PHPMailer\\PHPMailer\\PHPMailer');
$sent = false;
if ($useMailer) {
  try {
    $mailer = new PHPMailer\PHPMailer\PHPMailer(true);
    if (SMTP_HOST && SMTP_USER && SMTP_PASS) {
      $mailer->isSMTP();
      $mailer->Host = SMTP_HOST;
      $mailer->SMTPAuth = true;
      $mailer->Username = SMTP_USER;
      $mailer->Password = SMTP_PASS;
      $mailer->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
      $mailer->Port = SMTP_PORT;
    }
    $mailer->setFrom(TO_EMAIL, TO_NAME);
    $mailer->addAddress(TO_EMAIL, TO_NAME);
    $mailer->addCC($email, $name); // Send CC to the person who submitted the form
    $mailer->addReplyTo($email, $name);
    $mailer->Subject = 'New website enquiry from ' . h($name);
    $mailer->Body = $body;
    $sent = $mailer->send();
  } catch (Exception $e) {
    $sent = false;
  }
} else {
  $headers = 'From: '.TO_NAME.' <'.TO_EMAIL."\r\n".
             'Reply-To: '.h($name).' <'.h($email).">\r\n".
             'X-Mailer: PHP/' . phpversion();
  $sent = @mail(TO_EMAIL, 'New website enquiry', $body, $headers);
}

// Response page
?><!doctype html>
<html lang="en-GB"><head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo $sent ? 'Thanks — message received' : 'Sorry — something went wrong'; ?></title>
  <meta name="description" content="Contact confirmation">
  <link rel="canonical" href="https://neilwiddowson.co.uk/contact/">
  <link rel="stylesheet" href="/assets/css/app.css">
</head>
<body class="bg-gray-50 text-gray-900">
  <main class="section">
    <div class="container max-w-2xl">
      <div class="card p-6">
        <?php if ($sent): ?>
          <h1 class="text-2xl font-semibold">Thanks — I’ll be in touch shortly.</h1>
          <p class="mt-3 text-gray-700">I’ve sent a quick auto‑reply to confirm I got your message.</p>
          <a class="btn-primary mt-6 inline-flex" href="/index.html">Back to home</a>
        <?php else: ?>
          <h1 class="text-2xl font-semibold">Sorry — something went wrong.</h1>
          <p class="mt-3 text-gray-700">Please email <a class="underline" href="mailto:<?php echo h(TO_EMAIL); ?>"><?php echo h(TO_EMAIL); ?></a> and I’ll respond quickly.</p>
          <a class="btn-secondary mt-6 inline-flex" href="/contact/index.html">Try again</a>
        <?php endif; ?>
      </div>
    </div>
  </main>
</body></html>


