<?php
// Minimal contact handler with PHPMailer and spam protection
// Google Workspace SMTP configuration (IP-based authentication)
const SMTP_HOST = 'smtp.gmail.com';
const SMTP_USER = 'neil@neilwiddowson.co.uk';
const SMTP_PASS = ''; // No password needed for IP-based auth
const SMTP_PORT = 587;
const TO_EMAIL  = 'neil@neilwiddowson.co.uk';
const TO_NAME   = 'Neil Widdowson';

// Basic config
header('Content-Type: text/html; charset=utf-8');
function h($v) { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

// Validate request method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo '<p>Method not allowed.</p>';
  exit;
}

// Simple spam checks
$honeypot = $_POST['website'] ?? '';
if (!empty($honeypot)) {
  http_response_code(400);
  echo '<p>Thanks! Your message has been received.</p>'; // silent fail for bots
  exit;
}

// Required fields
$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$company = trim($_POST['company'] ?? '');
$message = trim($_POST['message'] ?? '');

if (!$name || !$email || !$company || !$message) {
  http_response_code(400);
  echo '<p>Please complete all required fields.</p>';
  exit;
}

// Compose email body
$body = "New enquiry from website:\n\n" .
        "Name: " . h($name) . "\n" .
        "Email: " . h($email) . "\n" .
        "Company: " . h($company) . "\n\n" .
        "Message:\n" . h($message) . "\n";

// Try to send mail; if PHPMailer not present, fallback to mail()
$useMailer = class_exists('PHPMailer\\PHPMailer\\PHPMailer');
$sent = false;
$error_message = '';

if ($useMailer) {
  try {
    $mailer = new PHPMailer\PHPMailer\PHPMailer(true);
    $mailer->SMTPDebug = 2; // Enable verbose debug output
    $mailer->isSMTP();
    $mailer->Host = SMTP_HOST;
    $mailer->SMTPAuth = false; // IP-based authentication
    $mailer->Username = SMTP_USER;
    $mailer->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
    $mailer->Port = SMTP_PORT;
    $mailer->setFrom(TO_EMAIL, TO_NAME);
    $mailer->addAddress(TO_EMAIL, TO_NAME);
    $mailer->addCC($email, $name); // Send CC to the person who submitted the form
    $mailer->addReplyTo($email, $name);
    $mailer->Subject = 'New website enquiry from ' . h($name);
    $mailer->Body = $body;
    $sent = $mailer->send();
  } catch (Exception $e) {
    $sent = false;
    $error_message = 'PHPMailer Error: ' . $e->getMessage();
  }
} else {
  $headers = 'From: '.TO_NAME.' <'.TO_EMAIL."\r\n".
             'Reply-To: '.h($name).' <'.h($email).">\r\n".
             'X-Mailer: PHP/' . phpversion();
  $sent = @mail(TO_EMAIL, 'New website enquiry', $body, $headers);
  if (!$sent) {
    $error_message = 'PHP mail() function failed';
  }
}

// Log error for debugging
if (!$sent) {
  error_log("Contact form error: " . $error_message);
  error_log("SMTP Config - Host: " . SMTP_HOST . ", User: " . SMTP_USER . ", Port: " . SMTP_PORT);
}

// Redirect after sending
if ($sent) {
  header('Location: https://neilwiddowson.co.uk/?success=1');
  exit;
} else {
  header('Location: https://neilwiddowson.co.uk/contact/?error=1&msg=' . urlencode($error_message));
  exit;
}


