<div class="space-y-4">
    @if (session('status'))
        <div class="text-green-600">{{ session('status') }}</div>
    @endif
    <form wire:submit.prevent="submit" class="space-y-4">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium">Date</label>
                <input type="date" wire:model.defer="receipt_date" class="mt-1 w-full border rounded px-3 py-2" required>
            </div>
            <div>
                <label class="block text-sm font-medium">Merchant</label>
                <input type="text" wire:model.defer="merchant_name" class="mt-1 w-full border rounded px-3 py-2">
            </div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <label class="block text-sm font-medium">Amount</label>
                <input type="number" step="0.01" wire:model.defer="total_amount" class="mt-1 w-full border rounded px-3 py-2" required>
            </div>
            <div>
                <label class="block text-sm font-medium">Currency</label>
                <input type="text" wire:model.defer="currency" class="mt-1 w-full border rounded px-3 py-2" maxlength="3">
            </div>
            <div class="flex items-center space-x-2">
                <label class="block text-sm font-medium">Personal?</label>
                <input type="checkbox" wire:model.defer="is_personal" class="mt-1">
            </div>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium">Department</label>
                <select wire:model.defer="department_id" class="mt-1 w-full border rounded px-3 py-2">
                    <option value="">--</option>
                    @foreach ($departments as $d)
                        <option value="{{ $d->id }}">{{ $d->name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium">Account</label>
                <select wire:model.defer="account_id" class="mt-1 w-full border rounded px-3 py-2">
                    <option value="">--</option>
                    @foreach ($accounts as $a)
                        <option value="{{ $a->id }}">{{ $a->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div>
            <label class="block text-sm font-medium">Image</label>
            <input type="file" wire:model="image" accept="image/*" class="mt-1 w-full">
        </div>

        <div class="space-y-2">
            <div class="font-medium">Lines</div>
            @foreach ($lines as $i => $line)
                <div class="grid grid-cols-12 gap-2 items-center">
                    <input class="col-span-6 border rounded px-2 py-1" type="text" wire:model.defer="lines.{{ $i }}.description" placeholder="Description">
                    <input class="col-span-2 border rounded px-2 py-1" type="number" min="1" wire:model.defer="lines.{{ $i }}.quantity" placeholder="Qty">
                    <input class="col-span-2 border rounded px-2 py-1" type="number" step="0.01" wire:model.defer="lines.{{ $i }}.unit_price" placeholder="Unit">
                    <input class="col-span-2 border rounded px-2 py-1" type="number" step="0.01" wire:model.defer="lines.{{ $i }}.line_total" placeholder="Total">
                    <button type="button" class="text-sm text-red-600" wire:click="removeLine({{ $i }})">Remove</button>
                </div>
            @endforeach
            <button type="button" class="text-sm text-blue-600" wire:click="addLine">+ Add line</button>
        </div>

        <div>
            <x-primary-button type="submit" wire:loading.attr="disabled">Upload</x-primary-button>
            <span wire:loading class="ml-2 text-sm">Uploading...</span>
        </div>
    </form>
</div>
