<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Profile extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'display_name', 'goals', 'voice_prefs', 'sensitivity',
    ];

    protected $casts = [
        'goals' => 'array',
        'voice_prefs' => 'array',
        'sensitivity' => 'encrypted',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}


