<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('library_tracks', function (Blueprint $table) {
            $table->text('signed_url')->nullable()->after('file_path');
            $table->timestamp('signed_url_expires_at')->nullable()->after('signed_url');
            $table->timestamp('last_signed_url_generated_at')->nullable()->after('signed_url_expires_at');
            $table->text('last_signed_url_error')->nullable()->after('last_signed_url_generated_at');
            $table->timestamp('last_signed_url_error_at')->nullable()->after('last_signed_url_error');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('library_tracks', function (Blueprint $table) {
            $table->dropColumn([
                'signed_url',
                'signed_url_expires_at',
                'last_signed_url_generated_at',
                'last_signed_url_error',
                'last_signed_url_error_at'
            ]);
        });
    }
};
